/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.plant.Plant;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantBodyBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BodyPlantBlock
extends GrowingPlantBodyBlock
implements IForgeBlockExtension {
    public static final VoxelShape BODY_SHAPE = BodyPlantBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final VoxelShape THIN_BODY_SHAPE = BodyPlantBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final VoxelShape WEEPING_SHAPE = BodyPlantBlock.box((double)4.0, (double)9.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final VoxelShape TWISTING_SHAPE = BodyPlantBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0);
    public static final VoxelShape TWISTING_THIN_SHAPE = BodyPlantBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0);
    private final Supplier<? extends Block> headBlock;
    private final ExtendedProperties properties;
    private final Plant plant;

    public BodyPlantBlock(ExtendedProperties properties, Supplier<? extends Block> headBlock, VoxelShape shape, Direction direction, Plant plant) {
        super(properties.properties().dynamicShape().offsetType(BlockBehaviour.OffsetType.XZ), direction, shape, true);
        this.headBlock = headBlock;
        this.properties = properties;
        this.plant = plant;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.relative(this.growthDirection.getOpposite());
        BlockState blockstate = level.getBlockState(blockpos);
        Block block = blockstate.getBlock();
        if (!this.canAttachTo(blockstate)) {
            return false;
        }
        return block == this.getHeadBlock() || block == this.getBodyBlock() || Helpers.isBlock(blockstate, (TagKey<Block>)BlockTags.LEAVES) || blockstate.isFaceSturdy((BlockGetter)level, blockpos, this.growthDirection);
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    protected GrowingPlantHeadBlock getHeadBlock() {
        return (GrowingPlantHeadBlock)this.headBlock.get();
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)this.getHeadBlock());
    }

    protected MapCodec<? extends GrowingPlantBodyBlock> codec() {
        return this.fakeBlockCodec();
    }

    public RegistryPlant getPlant() {
        return this.plant;
    }
}

