/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.plant.PlantBlock;
import net.dries007.tfc.common.blocks.plant.PlantRegrowth;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class CreepingPlantBlock
extends PlantBlock
implements DirectionPropertyBlock {
    protected static final VoxelShape UP_SHAPE = CreepingPlantBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape DOWN_SHAPE = CreepingPlantBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape NORTH_SHAPE = CreepingPlantBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape EAST_SHAPE = CreepingPlantBlock.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = CreepingPlantBlock.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_SHAPE = CreepingPlantBlock.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    protected static final Map<BooleanProperty, VoxelShape> SHAPES = ImmutableMap.builder().put((Object)UP, (Object)UP_SHAPE).put((Object)DOWN, (Object)DOWN_SHAPE).put((Object)NORTH, (Object)NORTH_SHAPE).put((Object)SOUTH, (Object)SOUTH_SHAPE).put((Object)EAST, (Object)EAST_SHAPE).put((Object)WEST, (Object)WEST_SHAPE).build();
    protected final Map<BlockState, VoxelShape> shapeCache;

    public static CreepingPlantBlock create(final RegistryPlant plant, ExtendedProperties properties) {
        return new CreepingPlantBlock(properties){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }

            @Override
            public boolean canCreepOn(LevelReader level, BlockPos pos, BlockState state, Direction direction) {
                return !Helpers.isBlock(state, TFCTags.Blocks.CREEPING_PLANT_NOT_PLANTABLE_ON) && super.canCreepOn(level, pos, state, direction);
            }
        };
    }

    public static CreepingPlantBlock createStone(final RegistryPlant plant, ExtendedProperties properties) {
        return new CreepingPlantBlock(properties){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }

            @Override
            public boolean canCreepOn(LevelReader level, BlockPos pos, BlockState state, Direction direction) {
                return Helpers.isBlock(state, TFCTags.Blocks.CREEPING_STONE_PLANTABLE_ON) && super.canCreepOn(level, pos, state, direction);
            }
        };
    }

    protected CreepingPlantBlock(ExtendedProperties properties) {
        super(properties);
        this.registerDefaultState(DirectionPropertyBlock.setAllDirections((BlockState)this.getStateDefinition().any(), false));
        this.shapeCache = DirectionPropertyBlock.makeShapeCache((StateDefinition<Block, BlockState>)this.getStateDefinition(), SHAPES::get);
    }

    @Override
    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.randomTick(state, level, pos, random);
        if (PlantRegrowth.canSpread((Level)level, random, pos)) {
            BlockState newState;
            BlockPos newPos;
            Direction direction = Direction.getRandom((RandomSource)random);
            if (direction == Direction.DOWN) {
                direction = Direction.UP;
            }
            BlockPos blockPos = newPos = random.nextFloat() < 0.2f ? pos.relative(direction).above() : pos.relative(direction);
            if (level.getBlockState(newPos).isAir() && !(newState = CreepingPlantBlock.updateStateFromSides((LevelAccessor)level, newPos, state)).isAir()) {
                level.setBlockAndUpdate(newPos, newState);
            }
        }
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return CreepingPlantBlock.isEmptyContents(state = (BlockState)state.setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(this.canCreepOn((LevelReader)level, facingPos, facingState, direction)))) ? Blocks.AIR.defaultBlockState() : state;
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction direction : UPDATE_SHAPE_ORDER) {
            mutablePos.setWithOffset((Vec3i)pos, direction);
            if (!this.canCreepOn(level, (BlockPos)mutablePos, level.getBlockState((BlockPos)mutablePos), direction)) continue;
            return true;
        }
        return false;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, false);
        }
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapeCache.get(state);
    }

    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return CreepingPlantBlock.updateStateFromSides((LevelAccessor)context.getLevel(), context.getClickedPos(), this.defaultBlockState());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{UP, DOWN, NORTH, SOUTH, EAST, WEST}));
    }

    public static BlockState updateStateFromSides(LevelAccessor level, BlockPos pos, BlockState state) {
        CreepingPlantBlock block = (CreepingPlantBlock)state.getBlock();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        boolean hasEarth = false;
        for (Direction direction : UPDATE_SHAPE_ORDER) {
            mutablePos.setWithOffset((Vec3i)pos, direction);
            boolean ground = block.canCreepOn((LevelReader)level, pos, level.getBlockState((BlockPos)mutablePos), direction);
            state = (BlockState)state.setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(ground));
            hasEarth |= ground;
        }
        return hasEarth ? state : Blocks.AIR.defaultBlockState();
    }

    private static boolean isEmptyContents(BlockState state) {
        for (BooleanProperty property : SHAPES.keySet()) {
            if (!((Boolean)state.getValue((Property)property)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rot) {
        return DirectionPropertyBlock.rotate(state, rot);
    }

    @Override
    public BlockState mirror(BlockState state, Mirror mirror) {
        return DirectionPropertyBlock.mirror(state, mirror);
    }

    public boolean canCreepOn(LevelReader level, BlockPos pos, BlockState state, Direction direction) {
        return state.isFaceSturdy((BlockGetter)level, pos, direction.getOpposite());
    }
}

