/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.CreepingPlantBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class CreepingWaterPlantBlock
extends CreepingPlantBlock
implements IFluidLoggable {
    public static final BooleanProperty OPEN = TFCBlockStateProperties.OPEN;

    public static CreepingWaterPlantBlock create(final RegistryPlant plant, final FluidProperty fluid, ExtendedProperties properties) {
        return new CreepingWaterPlantBlock(properties){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }

            @Override
            public FluidProperty getFluidProperty() {
                return fluid;
            }

            @Override
            public boolean canCreepOn(LevelReader level, BlockPos pos, BlockState state, Direction direction) {
                return Helpers.isBlock(state, TFCTags.Blocks.ANEMONE_PLANTABLE_ON) && super.canCreepOn(level, pos, state, direction);
            }
        };
    }

    public static CreepingWaterPlantBlock createRock(final RegistryPlant plant, final FluidProperty fluid, ExtendedProperties properties) {
        return new CreepingWaterPlantBlock(properties){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }

            @Override
            public FluidProperty getFluidProperty() {
                return fluid;
            }

            @Override
            public boolean canCreepOn(LevelReader level, BlockPos pos, BlockState state, Direction direction) {
                return Helpers.isBlock(state, TFCTags.Blocks.CREEPING_STONE_PLANTABLE_ON) && super.canCreepOn(level, pos, state, direction);
            }
        };
    }

    protected CreepingWaterPlantBlock(ExtendedProperties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(Fluids.EMPTY))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Fluid fluid = context.getLevel().getFluidState(pos).getType();
        BlockState state = this.defaultBlockState();
        if (this.getFluidProperty().canContain(fluid)) {
            state = (BlockState)state.setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(fluid));
            if (fluid == TFCFluids.SALT_WATER.getSource()) {
                state = (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true));
            }
        }
        return CreepingWaterPlantBlock.updateStateFromSides((LevelAccessor)context.getLevel(), context.getClickedPos(), state);
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        state = (BlockState)state.setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(this.canCreepOn((LevelReader)level, facingPos, facingState, direction)));
        return CreepingWaterPlantBlock.isEmptyContents(state) ? Blocks.AIR.defaultBlockState() : state;
    }

    private static boolean isEmptyContents(BlockState state) {
        for (BooleanProperty property : SHAPES.keySet()) {
            if (!((Boolean)state.getValue((Property)property)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{OPEN}));
        builder.add(new Property[]{this.getFluidProperty()});
    }

    @Override
    public FluidState getFluidState(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isClientSide && level.getFluidState(pos).getType().isSame((Fluid)TFCFluids.SALT_WATER.getSource())) {
            if (level.getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)pos.getCenter(), (double)1.0, (double)1.0, (double)1.0)).isEmpty()) {
                level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true)), 3);
            } else {
                level.scheduleTick(pos, (Block)this, 160);
            }
        }
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.isClientSide && ((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)), 3);
            level.scheduleTick(pos, (Block)this, level.random.nextInt(40, 160));
        }
    }
}

