/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import java.util.HashSet;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.BranchingCactusBlock;
import net.dries007.tfc.common.blocks.plant.PlantBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class GrowingBranchingCactusBlock
extends BranchingCactusBlock {
    public static final BooleanProperty GROWS_BRANCHES = TFCBlockStateProperties.GROWS_BRANCHES;
    private final Supplier<? extends Block> body;
    private final Supplier<? extends Block> flower;

    public static GrowingBranchingCactusBlock createGrowing(ExtendedProperties properties, Supplier<? extends Block> body, Supplier<? extends Block> flower) {
        return new GrowingBranchingCactusBlock(0.3125f, properties, body, flower);
    }

    public GrowingBranchingCactusBlock(float size, ExtendedProperties properties, Supplier<? extends Block> body, Supplier<? extends Block> flower) {
        super(size, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)GROWS_BRANCHES, (Comparable)Boolean.valueOf(true))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false)));
        this.flower = flower;
        this.body = body;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{GROWS_BRANCHES}));
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if ((double)rand.nextFloat() > TFCConfig.SERVER.plantGrowthChance.get()) {
            this.growthTick((LevelAccessor)level, pos, state);
        }
    }

    public void growthTick(LevelAccessor level, BlockPos pos, BlockState state) {
        boolean willBranch;
        if (level.getBlockState(pos.above()).getBlock() instanceof BranchingCactusBlock) {
            level.setBlock(pos, Helpers.copyProperties(this.body.get().defaultBlockState(), state), 3);
            return;
        }
        if (((Boolean)state.getValue((Property)GROWS_BRANCHES)).booleanValue() || level.getRandom().nextFloat() < 0.1f) {
            if (level.getBlockState(pos.below(7)).getBlock() instanceof BranchingCactusBlock) {
                level.setBlock(pos, Helpers.copyProperties(this.body.get().defaultBlockState(), state), 3);
                this.tryFruit(level, pos.above());
                return;
            }
        } else if (level.getBlockState(pos.below(3)).getBlock() instanceof BranchingCactusBlock || level.getRandom().nextFloat() < 0.5f) {
            level.setBlock(pos, Helpers.copyProperties(this.body.get().defaultBlockState(), state), 3);
            this.tryFruit(level, pos.above());
            return;
        }
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        RandomSource random = level.getRandom();
        Direction dir = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        BlockState body = this.body.get().defaultBlockState();
        BranchingCactusBlock bodyBlock = (BranchingCactusBlock)body.getBlock();
        boolean bl = willBranch = random.nextFloat() < 0.7f && (Boolean)state.getValue((Property)GROWS_BRANCHES) != false;
        if (willBranch) {
            willBranch = GrowingBranchingCactusBlock.ensureNeighborhoodForBranch(level, pos, cursor, dir, willBranch);
        }
        cursor.setWithOffset((Vec3i)pos, 0, 1, 0);
        level.setBlock((BlockPos)cursor, (BlockState)this.getStateForPlacement((BlockGetter)level, (BlockPos)cursor).setValue((Property)GROWS_BRANCHES, (Comparable)((Boolean)state.getValue((Property)GROWS_BRANCHES))), 3);
        cursor.move(0, -1, 0);
        BlockState below = level.getBlockState((BlockPos)cursor);
        if (below.getBlock() == this) {
            level.setBlock((BlockPos)cursor, Helpers.copyProperties(body, below), 3);
        }
        cursor.move(0, 1, 0);
        if (willBranch && this.canGrowInto(level, (BlockPos)cursor.move(dir), dir) && this.canGrowInto(level, (BlockPos)cursor.move(dir), dir) && this.canGrowInto(level, (BlockPos)cursor.move(0, 1, 0), Direction.UP)) {
            cursor.setWithOffset((Vec3i)pos, dir);
            level.setBlock((BlockPos)cursor, bodyBlock.getStateForPlacement((BlockGetter)level, (BlockPos)cursor), 3);
            cursor.move(dir);
            level.setBlock((BlockPos)cursor, (BlockState)((BlockState)this.getStateForPlacement((BlockGetter)level, (BlockPos)cursor).setValue((Property)GROWS_BRANCHES, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    private static boolean ensureNeighborhoodForBranch(LevelAccessor level, BlockPos pos, BlockPos.MutableBlockPos cursor, Direction dir, boolean willBranch) {
        int i;
        cursor.move(0, -1, 0);
        if (!(level.getBlockState((BlockPos)cursor).getBlock() instanceof BranchingCactusBlock)) {
            willBranch = false;
        }
        cursor.setWithOffset((Vec3i)pos, dir);
        for (i = 0; i < 2; ++i) {
            cursor.move(0, -1, 0);
            if (!(level.getBlockState((BlockPos)cursor).getBlock() instanceof BranchingCactusBlock)) continue;
            willBranch = false;
        }
        cursor.setWithOffset((Vec3i)pos, dir);
        for (i = 0; i < 3; ++i) {
            cursor.move(0, 1, 0);
            if (!(level.getBlockState((BlockPos)cursor).getBlock() instanceof BranchingCactusBlock)) continue;
            willBranch = false;
        }
        return willBranch;
    }

    public boolean growRecursively(LevelAccessor level, BlockPos pos, BlockState state, int height) {
        BlockState body = this.body.get().defaultBlockState();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        RandomSource random = level.getRandom();
        cursor.move(0, -1, 0);
        if (!(this.testDown(state) && this.canGrowInto(level, pos, Direction.UP) && this.canGrowInto(level, pos.above(), Direction.UP))) {
            return false;
        }
        HashSet<Direction> usedDirections = new HashSet<Direction>();
        for (int i = 0; i < height; ++i) {
            Direction dir;
            BlockState placeState = (BlockState)((BlockState)body.setValue((Property)DOWN, (Comparable)Boolean.valueOf(true))).setValue((Property)UP, (Comparable)Boolean.valueOf(true));
            cursor.setWithOffset((Vec3i)pos, 0, i, 0);
            if (i == height - 1) {
                cursor.move(0, 1, 0);
                this.tryFruit(level, (BlockPos)cursor);
                cursor.move(0, -1, 0);
            }
            if (!this.canGrowInto(level, (BlockPos)cursor, Direction.UP)) {
                return true;
            }
            if (i == height - 1) {
                placeState = Helpers.copyProperties(body, placeState);
            }
            level.setBlock((BlockPos)cursor, placeState, 3);
            if (!((Boolean)state.getValue((Property)GROWS_BRANCHES)).booleanValue() || i <= 2 || !(random.nextFloat() < 0.6f) || i >= height - 1 || usedDirections.contains(dir = Direction.Plane.HORIZONTAL.getRandomDirection(random)) || !this.canGrowInto(level, (BlockPos)cursor.move(dir), dir) || !this.canGrowInto(level, (BlockPos)cursor.move(dir), dir) || !this.canGrowInto(level, (BlockPos)cursor.move(0, 1, 0), Direction.UP)) continue;
            usedDirections.add(dir);
            cursor.setWithOffset((Vec3i)pos, dir).move(0, i, 0);
            level.setBlock((BlockPos)cursor, (BlockState)((BlockState)body.setValue((Property)PROPERTY_BY_DIRECTION.get(dir), (Comparable)Boolean.valueOf(true))).setValue((Property)PROPERTY_BY_DIRECTION.get(dir.getOpposite()), (Comparable)Boolean.valueOf(true)), 3);
            cursor.move(dir);
            BlockState newState = (BlockState)((BlockState)((BlockState)state.setValue((Property)GROWS_BRANCHES, (Comparable)Boolean.valueOf(false))).setValue((Property)PROPERTY_BY_DIRECTION.get(dir.getOpposite()), (Comparable)Boolean.valueOf(true))).setValue((Property)UP, (Comparable)Boolean.valueOf(true));
            level.setBlock((BlockPos)cursor, newState, 3);
            cursor.move(0, 1, 0);
            this.growRecursively(level, cursor.immutable(), newState, 3);
            cursor.setWithOffset((Vec3i)pos, 0, i, 0);
            level.setBlock((BlockPos)cursor, (BlockState)placeState.setValue((Property)PROPERTY_BY_DIRECTION.get(dir), (Comparable)Boolean.valueOf(true)), 3);
        }
        return true;
    }

    public boolean canGrowInto(LevelAccessor level, BlockPos pos, Direction direction) {
        if (!level.getBlockState(pos).isAir()) {
            return false;
        }
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (Direction dir : Helpers.DIRECTIONS) {
            cursor.setWithOffset((Vec3i)pos, dir);
            if (!level.isAreaLoaded((BlockPos)cursor, 1) || dir == direction.getOpposite() || !this.testHorizontal(level.getBlockState((BlockPos)cursor))) continue;
            return false;
        }
        return true;
    }

    private void tryFruit(LevelAccessor level, BlockPos pos) {
        if (level.getBlockState(pos).canBeReplaced()) {
            PlantBlock plant = (PlantBlock)this.flower.get();
            level.setBlock(pos, plant.defaultBlockState(), 3);
        }
    }
}

