/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import com.mojang.serialization.MapCodec;
import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class PipePlantBlock
extends PipeBlock
implements IForgeBlockExtension {
    private final ExtendedProperties properties;

    public PipePlantBlock(float size, ExtendedProperties properties) {
        super(size, properties.properties());
        this.properties = properties;
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN}));
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (!state.canSurvive((LevelReader)level, currentPos)) {
            level.scheduleTick(currentPos, (Block)this, 1);
            return state;
        }
        boolean exists = facing.getAxis().isHorizontal() && this.testHorizontal(facingState) || facing == Direction.DOWN && this.testDown(facingState) || facing == Direction.UP && this.testUp(facingState);
        return (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(facing), (Comparable)Boolean.valueOf(exists));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getStateForPlacement((BlockGetter)context.getLevel(), context.getClickedPos());
    }

    public BlockState getStateForPlacement(BlockGetter level, BlockPos pos) {
        BlockState down = level.getBlockState(pos.below());
        BlockState up = level.getBlockState(pos.above());
        BlockState north = level.getBlockState(pos.north());
        BlockState east = level.getBlockState(pos.east());
        BlockState south = level.getBlockState(pos.south());
        BlockState west = level.getBlockState(pos.west());
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)DOWN, (Comparable)Boolean.valueOf(this.testDown(down)))).setValue((Property)UP, (Comparable)Boolean.valueOf(this.testUp(up)))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.testHorizontal(north)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.testHorizontal(west)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.testHorizontal(east)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.testHorizontal(south)));
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            cursor.setWithOffset((Vec3i)pos, direction);
            if (!this.testHorizontal(level.getBlockState((BlockPos)cursor))) continue;
            cursor.move(0, -1, 0);
            if (this.testDown(level.getBlockState((BlockPos)cursor))) {
                return true;
            }
            if (!this.canGrowLongSideways()) continue;
            cursor.move(0, 1, 0);
            cursor.move(direction);
            if (!this.testHorizontal(level.getBlockState((BlockPos)cursor))) continue;
            return true;
        }
        cursor.setWithOffset((Vec3i)pos, 0, -1, 0);
        return this.testDown(level.getBlockState((BlockPos)cursor));
    }

    protected abstract boolean testDown(BlockState var1);

    protected abstract boolean testUp(BlockState var1);

    protected abstract boolean testHorizontal(BlockState var1);

    protected boolean canGrowLongSideways() {
        return false;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return DirectionPropertyBlock.rotate(state, rot);
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return DirectionPropertyBlock.mirror(state, mirror);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    protected MapCodec<? extends PipeBlock> codec() {
        return this.fakeBlockCodec();
    }
}

