/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import java.util.EnumSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.plant.BodyPlantBlock;
import net.dries007.tfc.common.blocks.plant.BranchingCactusBlock;
import net.dries007.tfc.common.blocks.plant.CreepingPlantBlock;
import net.dries007.tfc.common.blocks.plant.CreepingWaterPlantBlock;
import net.dries007.tfc.common.blocks.plant.EpiphytePlantBlock;
import net.dries007.tfc.common.blocks.plant.FloatingWaterPlantBlock;
import net.dries007.tfc.common.blocks.plant.GrowingBranchingCactusBlock;
import net.dries007.tfc.common.blocks.plant.KelpTreeBlock;
import net.dries007.tfc.common.blocks.plant.KelpTreeFlowerBlock;
import net.dries007.tfc.common.blocks.plant.PlantBlock;
import net.dries007.tfc.common.blocks.plant.RotatableWaterPlantBlock;
import net.dries007.tfc.common.blocks.plant.ShortGrassBlock;
import net.dries007.tfc.common.blocks.plant.TFCBambooSaplingBlock;
import net.dries007.tfc.common.blocks.plant.TFCBambooStalkBlock;
import net.dries007.tfc.common.blocks.plant.TFCCactusBedBlock;
import net.dries007.tfc.common.blocks.plant.TFCCactusBlock;
import net.dries007.tfc.common.blocks.plant.TFCKelpBlock;
import net.dries007.tfc.common.blocks.plant.TFCKelpTopBlock;
import net.dries007.tfc.common.blocks.plant.TFCPassableCactusBlock;
import net.dries007.tfc.common.blocks.plant.TFCSeagrassBlock;
import net.dries007.tfc.common.blocks.plant.TFCTallGrassBlock;
import net.dries007.tfc.common.blocks.plant.TFCTallShrubBlock;
import net.dries007.tfc.common.blocks.plant.TFCVineBlock;
import net.dries007.tfc.common.blocks.plant.TallWaterPlantBlock;
import net.dries007.tfc.common.blocks.plant.TopPlantBlock;
import net.dries007.tfc.common.blocks.plant.WaterPlantBlock;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PlaceOnWaterBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.Nullable;

public enum Plant implements RegistryPlant
{
    ATHYRIUM_FERN(BlockType.STANDARD, 0.7f),
    CANNA(BlockType.STANDARD, 0.7f, false, -0.1f, 0.43f, 0.51f, 0.6f, 0.74f, 0.93f),
    GOLDENROD(BlockType.STANDARD, 1.0f, false, -0.06f, 0.38f, 0.45f, 0.51f, 0.72f, 0.89f),
    PAMPAS_GRASS(BlockType.TALL_GRASS, 0.8f, true, 0.0f, 0.4f, 0.45f, 0.5f, 0.8f, 0.9f),
    PEROVSKIA(BlockType.DRY, 1.0f, false, 0.03f, 0.33f, 0.42f, 0.5f, 0.66f, 0.87f),
    ROSE(BlockType.TALL_GRASS, 0.6f, false, -0.167f, 0.42f, 0.5f, 0.61f, 0.76f, 0.92f),
    BEACHGRASS(BlockType.BEACH_GRASS, 0.9f),
    BLUEGRASS(BlockType.SHORT_GRASS, 0.9f, false, -0.08f, 0.5f, 0.55f, 0.6f, 0.75f, 0.89f),
    BROMEGRASS(BlockType.SHORT_GRASS, 0.9f, false, -0.14f, 0.5f, 0.55f, 0.6f, 0.75f, 0.89f),
    FOUNTAIN_GRASS(BlockType.SHORT_GRASS, 0.9f),
    MANATEE_GRASS(BlockType.GRASS_WATER, 0.8f),
    ORCHARD_GRASS(BlockType.SHORT_GRASS, 0.9f),
    RYEGRASS(BlockType.SHORT_GRASS, 0.9f, false, -0.19f, 0.46f, 0.55f, 0.6f, 0.75f, 0.89f),
    SCUTCH_GRASS(BlockType.SHORT_GRASS, 0.9f),
    STAR_GRASS(BlockType.GRASS_WATER, 0.8f),
    TIMOTHY_GRASS(BlockType.SHORT_GRASS, 0.9f),
    RADDIA_GRASS(BlockType.SHORT_GRASS, 0.9f),
    RED_OAT_GRASS(BlockType.SHORT_GRASS, 0.9f, true, -0.1f, 0.33f, 0.45f, 0.55f, 0.75f, 0.85f),
    ANEMONE_GREEN(BlockType.OCEAN_CREEPING, 1.0f),
    ANEMONE_PURPLE(BlockType.OCEAN_CREEPING, 1.0f),
    ANEMONE_LARGE_ORANGE(BlockType.OCEAN_ROTATABLE, 1.0f),
    ANEMONE_LARGE_PURPLE(BlockType.OCEAN_ROTATABLE, 1.0f),
    BARNACLES(BlockType.OCEAN_ROCK_CREEPING, 1.0f),
    MUSSELS(BlockType.OCEAN_ROCK_CREEPING, 1.0f),
    STARFISH(BlockType.OCEAN_ROTATABLE, 1.0f),
    ALLIUM(BlockType.STANDARD, 1.0f, false, -0.15f, 0.2f, 0.3f, 0.4f, 0.64f, 0.92f),
    ANTHURIUM(BlockType.STANDARD, 1.0f),
    ARROWHEAD(BlockType.TALL_WATER_FRESH, 0.6f),
    AZALEA(BlockType.TALL_SHRUB, 0.4f, false, -0.25f, 0.2f, 0.35f, 0.5f, 0.75f, 0.9f),
    BADDERLOCKS(BlockType.TALL_WATER, 0.8f),
    BARREL_CACTUS(BlockType.CACTUS, 0.0f, false, -0.25f, 0.24f, 0.36f, 0.5f, 0.73f, 0.9f),
    BEAR_GRASS(BlockType.TALL_GRASS, 0.6f, false, 0.05f, 0.25f, 0.35f, 0.4f, 0.7f, 0.8f),
    BIRD_NEST_FERN(BlockType.PERCHED_EPIPHYTE, 0.9f),
    BLOOD_LILY(BlockType.STANDARD, 1.0f, false, -0.167f, 0.333f, 0.431f, 0.523f, 0.845f, 0.878f),
    BLUE_GINGER(BlockType.STANDARD, 1.0f),
    BLUE_ORCHID(BlockType.STANDARD, 1.0f),
    BUR_REED(BlockType.TALL_WATER_FRESH, 0.6f, false, 0.0f, 0.19f, 0.27f, 0.5f, 0.72f, 0.88f),
    BUTTERCUP(BlockType.FLOWERBED, 1.0f, false, -0.2f, 0.35f, 0.45f, 0.55f, 0.65f, 0.9f),
    BUTTERFLY_MILKWEED(BlockType.STANDARD, 1.0f, false, -0.11f, 0.378f, 0.49f, 0.62f, 0.78f, 0.94f),
    BLACK_ORCHID(BlockType.STANDARD, 1.0f),
    CALENDULA(BlockType.STANDARD, 1.0f, false, -0.074f, 0.31f, 0.43f, 0.56f, 0.7f, 0.92f),
    CATTAIL(BlockType.TALL_WATER_FRESH, 0.6f, false, -0.21f, 0.28f, 0.41f, 0.52f, 0.73f, 0.9f),
    COBBLESTONE_LICHEN(BlockType.CREEPING_STONE, 1.0f),
    COONTAIL(BlockType.GRASS_WATER_FRESH, 0.8f),
    CORDGRASS(BlockType.TALL_WATER, 0.6f, false, 0.0f, 0.27f, 0.39f, 0.5f, 0.666f, 0.92f),
    CORNFLOWER(BlockType.STANDARD, 1.0f, false, -0.1f, 0.28f, 0.46f, 0.57f, 0.71f, 0.93f),
    DANDELION(BlockType.STANDARD, 1.0f, false, -0.15f, 0.28f, 0.46f, 0.57f, 0.71f, 0.93f),
    DEAD_BUSH(BlockType.DRY, 0.7f),
    DESERT_FLAME(BlockType.STANDARD, 1.0f, true, -0.5f, 0.33f, 0.42f, 0.5f, 0.833f, 0.92f),
    DRY_GRASS(BlockType.DRY, 0.9f),
    DUCKWEED(BlockType.FLOATING_FRESH, 0.7f),
    EDELWEISS(BlockType.STANDARD, 1.0f, false, -0.09f, 0.2f, 0.35f, 0.5f, 0.75f, 0.9f),
    EEL_GRASS(BlockType.GRASS_WATER_FRESH, 0.8f),
    ELEGANT_SUNBURST_LICHEN(BlockType.CREEPING_STONE, 1.0f),
    FAN_PALM(BlockType.TALL_GRASS, 0.6f),
    FIELD_HORSETAIL(BlockType.STANDARD, 0.9f),
    FOXGLOVE(BlockType.TALL_GRASS, 0.6f, false, -0.087f, 0.333f, 0.43f, 0.5f, 0.072f, 0.091f),
    GRAPE_HYACINTH(BlockType.STANDARD, 1.0f, false, -0.333f, 0.25f, 0.38f, 0.63f, 0.72f, 0.93f),
    GREEN_ALGAE(BlockType.FLOATING_FRESH, 0.7f),
    GUTWEED(BlockType.WATER, 0.8f),
    GUZMANIA(BlockType.EPIPHYTE, 1.0f),
    HELICONIA(BlockType.STANDARD, 1.0f),
    HEATHER(BlockType.STANDARD, 0.6f, false, -0.065f, 0.42f, 0.53f, 0.59f, 0.74f, 0.9f),
    HIBISCUS(BlockType.TALL_SHRUB, 0.4f, false, -0.12f, 0.41f, 0.52f, 0.61f, 0.74f, 0.89f),
    HOUSTONIA(BlockType.STANDARD, 1.0f, false, -0.25f, 0.29f, 0.41f, 0.62f, 0.76f, 0.92f),
    KANGAROO_PAW(BlockType.STANDARD, 1.0f, true, -0.25f, 0.32f, 0.44f, 0.55f, 0.68f, 0.88f),
    KING_FERN(BlockType.TALL_GRASS, 0.4f),
    KINNIKINNICK(BlockType.SHORT_SHRUB, 0.9f, false, -0.11f, 0.065f, 0.14f, 0.39f, 0.85f, 0.95f),
    LABRADOR_TEA(BlockType.STANDARD, 1.0f, false, -0.15f, 0.2f, 0.3f, 0.4f, 0.74f, 0.9f),
    LADY_FERN(BlockType.STANDARD, 0.6f),
    LAMINARIA(BlockType.WATER, 0.9f),
    LICORICE_FERN(BlockType.EPIPHYTE, 1.0f),
    ARTISTS_CONK(BlockType.EPIPHYTE, 1.0f),
    LILY_OF_THE_VALLEY(BlockType.STANDARD, 1.0f, false, -0.167f, 0.18f, 0.29f, 0.5f, 0.72f, 0.9f),
    LILAC(BlockType.TALL_GRASS, 0.6f, false, -0.21f, 0.18f, 0.29f, 0.45f, 0.73f, 0.9f),
    LOTUS(BlockType.FLOATING_FRESH, 0.7f, true, -0.12f, 0.25f, 0.35f, 0.5f, 0.75f, 0.92f, 1000, 13000),
    MAIDEN_PINK(BlockType.FLOWERBED, 1.0f, false, -0.333f, 0.5f, 0.6f, 0.7f, 0.8f, 0.9f),
    MARIGOLD(BlockType.TALL_WATER_FRESH, 0.6f, false, 0.14f, 0.18f, 0.26f, 0.35f, 0.58f, 0.86f),
    MEADS_MILKWEED(BlockType.STANDARD, 1.0f, false, -0.17f, 0.18f, 0.29f, 0.5f, 0.72f, 0.93f),
    MILFOIL(BlockType.WATER_FRESH, 0.8f),
    MORNING_GLORY(BlockType.CREEPING, 0.8f, false, -0.083f, 0.333f, 0.417f, 0.5f, 0.75f, 0.917f, 21000, 5000),
    MOUNTAIN_HULLWORT(BlockType.TALL_SHRUB, 0.4f),
    MOSS(BlockType.CREEPING, 1.0f),
    MOSS_CAMPION(BlockType.DRY, 0.9f, false, 0.05f, 0.15f, 0.25f, 0.45f, 0.85f, 0.92f),
    NASTURTIUM(BlockType.STANDARD, 1.0f, true),
    OSTRICH_FERN(BlockType.TALL_GRASS, 0.6f),
    OXEYE_DAISY(BlockType.STANDARD, 0.9f, false, 0.09f, 0.31f, 0.42f, 0.52f, 0.73f, 0.92f),
    PALASH(BlockType.TALL_SHRUB, 0.4f, true, 0.55f, 0.2f, 0.35f, 0.7f, 0.8f, 0.9f),
    PENWORTEL(BlockType.SHRUB, 0.4f, true, 0.3f, 0.25f, 0.35f, 0.45f, 0.6f, 0.8f),
    PHILODENDRON(BlockType.CREEPING, 0.7f),
    PHRAGMITE(BlockType.TALL_WATER_FRESH, 0.6f, false, 0.06f, 0.23f, 0.34f, 0.43f, 0.66f, 0.88f),
    PICKERELWEED(BlockType.TALL_WATER_FRESH, 0.6f, false, -0.9f, 0.32f, 0.43f, 0.52f, 0.77f, 0.91f),
    PISTIA(BlockType.FLOATING_FRESH, 0.8f),
    POPPY(BlockType.STANDARD, 1.0f, false, -0.25f, 0.23f, 0.33f, 0.58f, 0.79f, 0.92f),
    PRICKLY_PEAR(BlockType.PASSABLE_CACTUS, 0.3f, true, -0.13f, 0.16f, 0.32f, 0.5f, 0.75f, 0.92f),
    PRICKLY_PEAR_PURPLE(BlockType.PASSABLE_CACTUS, 0.3f, true, -0.13f, 0.16f, 0.32f, 0.5f, 0.75f, 0.92f),
    PRIMROSE(BlockType.STANDARD, 1.0f, false, -0.4f, 0.34f, 0.41f, 0.8f, 0.89f, 0.95f),
    PULSATILLA(BlockType.STANDARD, 1.0f, false, -0.31f, 0.168f, 0.25f, 0.73f, 0.84f, 0.93f),
    QANTU(BlockType.SHRUB, 0.4f, false, -0.33f, 0.25f, 0.35f, 0.5f, 0.65f, 0.9f),
    RAMIREZELLA(BlockType.EPIPHYTE, 1.0f),
    RAMUNDA(BlockType.STANDARD, 1.0f, false, -0.12f, 0.22f, 0.3f, 0.45f, 0.7f, 0.9f),
    RED_ALGAE(BlockType.FLOATING, 0.7f),
    REINDEER_LICHEN(BlockType.CREEPING, 1.0f),
    RED_SEALING_WAX_PALM(BlockType.TALL_GRASS, 0.4f),
    SACRED_DATURA(BlockType.STANDARD, 1.0f, false, -0.2f, 0.4f, 0.5f, 0.6f, 0.8f, 0.95f, 12000, 0),
    SAGEBRUSH(BlockType.DRY, 0.5f, false, -0.09f, 0.48f, 0.54f, 0.6f, 0.72f, 0.91f),
    SAGO(BlockType.WATER_FRESH, 0.8f),
    SAGUARO_FRUIT(BlockType.CACTUS_FLOWER, 0.7f, true, -0.2f, 0.22f, 0.3f, 0.5f, 0.73f, 0.9f),
    SAPPHIRE_TOWER(BlockType.TALL_GRASS, 0.6f, true, -0.05f, 0.1f, 0.2f, 0.52f, 0.76f, 0.92f),
    SARGASSUM(BlockType.FLOATING, 0.7f),
    SEA_LAVENDER(BlockType.TALL_WATER, 0.6f, false, 0.08f, 0.18f, 0.31f, 0.4f, 0.7f, 0.91f),
    SEA_PALM(BlockType.DRY, 0.6f),
    SHAWIASH(BlockType.SHRUB, 0.9f, false, -0.09f, 0.07f, 0.14f, 0.4f, 0.85f, 0.95f),
    SILKEN_PINCUSHION_CACTUS(BlockType.CACTUSBED, 0.0f, true, -0.2f, 0.25f, 0.4f, 0.6f, 0.75f, 0.9f),
    SILVER_BROMELIAD(BlockType.PERCHED_EPIPHYTE, 0.9f),
    SILVER_SPURFLOWER(BlockType.STANDARD, 1.0f, false, 0.02f, 0.17f, 0.26f, 0.39f, 0.65f, 0.9f),
    SNAPDRAGON_PINK(BlockType.STANDARD, 1.0f, false, -0.08f, 0.28f, 0.4f, 0.5f, 0.72f, 0.89f),
    SNAPDRAGON_RED(BlockType.STANDARD, 1.0f, false, -0.09f, 0.28f, 0.4f, 0.5f, 0.72f, 0.89f),
    SNAPDRAGON_WHITE(BlockType.STANDARD, 1.0f, false, -0.04f, 0.28f, 0.4f, 0.5f, 0.72f, 0.89f),
    SNAPDRAGON_YELLOW(BlockType.STANDARD, 1.0f, false, -0.06f, 0.28f, 0.4f, 0.5f, 0.72f, 0.89f),
    STRELITZIA(BlockType.STANDARD, 1.0f, true, -0.333f, 0.417f, 0.5f, 0.61f, 0.75f, 0.9f),
    SUNFLOWER(BlockType.TALL_GRASS, 0.6f, false, 0.12f, 0.12f, 0.21f, 0.34f, 0.63f, 0.88f),
    SWITCHGRASS(BlockType.TALL_GRASS, 0.8f, false, -0.14f, 0.38f, 0.49f, 0.58f, 0.77f, 0.93f),
    SWORD_FERN(BlockType.STANDARD, 0.6f),
    TALL_FESCUE_GRASS(BlockType.TALL_GRASS, 0.5f),
    TANK_BROMELIAD(BlockType.PERCHED_EPIPHYTE, 0.9f),
    TOQUILLA_PALM(BlockType.TALL_GRASS, 0.6f),
    TRILLIUM(BlockType.STANDARD, 1.0f, false, -0.27f, 0.24f, 0.32f, 0.61f, 0.83f, 0.92f),
    TROPICAL_MILKWEED(BlockType.STANDARD, 1.0f),
    TULIP_ORANGE(BlockType.STANDARD, 1.0f, false, -0.21f, 0.12f, 0.2f, 0.62f, 0.86f, 0.94f),
    TULIP_PINK(BlockType.STANDARD, 1.0f, false, -0.2f, 0.12f, 0.2f, 0.62f, 0.86f, 0.94f),
    TULIP_RED(BlockType.STANDARD, 1.0f, false, -0.24f, 0.12f, 0.2f, 0.62f, 0.86f, 0.94f),
    TULIP_WHITE(BlockType.STANDARD, 1.0f, false, -0.23f, 0.12f, 0.2f, 0.62f, 0.86f, 0.94f),
    TURTLE_GRASS(BlockType.GRASS_WATER, 0.8f),
    VRIESEA(BlockType.EPIPHYTE, 1.0f),
    WATER_CANNA(BlockType.FLOATING_FRESH, 0.8f),
    WHITE_WATER_LILY(BlockType.FLOATING_FRESH, 0.7f, false, -0.11f, 0.33f, 0.42f, 0.5f, 0.8f, 0.92f),
    PURPLE_WATER_LILY(BlockType.FLOATING_FRESH, 0.7f, false, -0.05f, 0.32f, 0.41f, 0.5f, 0.8f, 0.92f),
    YELLOW_WATER_LILY(BlockType.FLOATING_FRESH, 0.7f, false, -0.083f, 0.32f, 0.41f, 0.5f, 0.8f, 0.92f),
    WATER_TARO(BlockType.TALL_WATER_FRESH, 0.6f),
    YELLOW_SAXIFRAGE(BlockType.FLOWERBED, 1.0f, false, -0.12f, 0.31f, 0.4f, 0.5f, 0.65f, 0.9f),
    YUCCA(BlockType.DRY, 0.8f, true, -0.12f, 0.31f, 0.42f, 0.51f, 0.72f, 0.9f),
    HANGING_VINES_PLANT(BlockType.WEEPING, 1.0f),
    HANGING_VINES(BlockType.WEEPING_TOP, 1.0f),
    SPANISH_MOSS_PLANT(BlockType.WEEPING, 1.0f),
    SPANISH_MOSS(BlockType.WEEPING_TOP, 1.0f),
    LIANA_PLANT(BlockType.WEEPING, 1.0f),
    LIANA(BlockType.WEEPING_TOP, 1.0f),
    FLAME_VINE_PLANT(BlockType.WEEPING, 1.0f, true, 0.49f, 0.4f, 0.5f, 0.6f, 0.8f, 0.9f),
    FLAME_VINE(BlockType.WEEPING_TOP, 1.0f, true, 0.49f, 0.4f, 0.5f, 0.6f, 0.8f, 0.9f),
    TREE_FERN_PLANT(BlockType.TWISTING_SOLID, 0.0f),
    TREE_FERN(BlockType.TWISTING_SOLID_TOP, 0.0f),
    CYCAD_PLANT(BlockType.TWISTING_SOLID, 0.0f),
    CYCAD(BlockType.TWISTING_SOLID_TOP, 0.0f),
    ARUNDO_PLANT(BlockType.TWISTING, 0.3f),
    ARUNDO(BlockType.TWISTING_TOP, 0.3f),
    DRY_PHRAGMITE_PLANT(BlockType.TWISTING, 0.3f),
    DRY_PHRAGMITE(BlockType.TWISTING_TOP_SHORT, 0.3f),
    WINGED_KELP_PLANT(BlockType.KELP, 0.7f),
    WINGED_KELP(BlockType.KELP_TOP, 1.0f),
    LEAFY_KELP_PLANT(BlockType.KELP, 0.7f),
    LEAFY_KELP(BlockType.KELP_TOP, 1.0f),
    GIANT_KELP_PLANT(BlockType.KELP_TREE, 0.2f),
    GIANT_KELP_FLOWER(BlockType.KELP_TREE_FLOWER, 1.0f),
    IVY(BlockType.CREEPING, 1.0f),
    JUNGLE_VINES(BlockType.VINE, 1.0f),
    SAGUARO_PLANT(BlockType.BRANCHING_CACTUS, 1.0f),
    SAGUARO(BlockType.BRANCHING_CACTUS_TOP, 1.0f),
    GOLDEN_BAMBOO(BlockType.BAMBOO, 1.0f),
    GOLDEN_BAMBOO_SAPLING(BlockType.BAMBOO_SAPLING, 1.0f);

    private static final EnumSet<Plant> SPECIAL_POTTED_PLANTS;
    private static final EnumSet<Plant> BLOCK_TINTED_PLANTS;
    private static final EnumSet<Plant> ITEM_TINTED_PLANTS;
    private static final EnumSet<Plant> FLOWERPOT_TINTED_PLANTS;
    private static final EnumSet<Plant> FOLIAGE_COLOR_PLANTS;
    private static final EnumSet<Plant> WATER_COLOR_PLANTS;
    @Nullable
    private final IntegerProperty ageProperty;
    private final float speedFactor;
    private final boolean isWetSeasonBlooming;
    private final float bloomOffset;
    private final float bloomingEnd;
    private final float seedingEnd;
    private final float dyingEnd;
    private final float dormantEnd;
    private final float sproutingEnd;
    private final int startHour;
    private final int endHour;
    private final BlockType type;

    private Plant(BlockType type, float speedFactor) {
        this(type, speedFactor, false);
    }

    private Plant(BlockType type, float speedFactor, boolean isWetSeasonBlooming) {
        this(type, speedFactor, isWetSeasonBlooming, -0.124f, 0.25f, 0.42f, 0.5f, 0.75f, 0.88f);
    }

    private Plant(BlockType type, float speedFactor, boolean isWetSeasonBlooming, float bloomOffset, float bloomingEnd, float seedingEnd, float dyingEnd, float dormantEnd, float sproutingEnd) {
        this(type, speedFactor, isWetSeasonBlooming, bloomOffset, bloomingEnd, seedingEnd, dyingEnd, dormantEnd, sproutingEnd, 0, 0);
    }

    private Plant(BlockType type, float speedFactor, boolean isWetSeasonBlooming, float bloomOffset, float bloomingEnd, float seedingEnd, float dyingEnd, float dormantEnd, float sproutingEnd, int startHour, int endHour) {
        this.type = type;
        this.speedFactor = speedFactor;
        this.isWetSeasonBlooming = isWetSeasonBlooming;
        this.bloomOffset = bloomOffset;
        this.bloomingEnd = bloomingEnd;
        this.seedingEnd = seedingEnd;
        this.dyingEnd = dyingEnd;
        this.dormantEnd = dormantEnd;
        this.sproutingEnd = sproutingEnd;
        this.startHour = startHour;
        this.endHour = endHour;
        int maxAge = this.getMaxAgeForType(type);
        this.ageProperty = maxAge > 0 ? TFCBlockStateProperties.getAgeProperty(maxAge) : null;
    }

    private int getMaxAgeForType(BlockType type) {
        if (type == BlockType.GRASS_WATER || type == BlockType.GRASS_WATER_FRESH || type == BlockType.BEACH_GRASS || type == BlockType.SHORT_GRASS || type == BlockType.TALL_GRASS || type == BlockType.FLOWERBED || type == BlockType.CACTUSBED || type == BlockType.FLOATING_FRESH || type == BlockType.FLOATING || type == BlockType.KELP_TREE || type == BlockType.KELP_TREE_FLOWER || type == BlockType.TWISTING_TOP || type == BlockType.TWISTING_SOLID_TOP || type == BlockType.BRANCHING_CACTUS_TOP || type == BlockType.KELP_TOP || type == BlockType.WEEPING_TOP || type == BlockType.TALL_WATER_FRESH || type == BlockType.TALL_SHRUB) {
            return 3;
        }
        return 0;
    }

    public Block create() {
        return this.type.factory.apply(this, this.type);
    }

    @Nullable
    public Function<Block, BlockItem> createBlockItem(Item.Properties properties) {
        return this.needsItem() ? block -> this.type.blockItemFactory.apply((Block)block, properties) : null;
    }

    @Override
    public boolean isWetSeasonBlooming() {
        return this.isWetSeasonBlooming;
    }

    @Override
    public int getStartTime() {
        return this.startHour;
    }

    @Override
    public int getEndTime() {
        return this.endHour;
    }

    @Override
    public float getBloomOffset() {
        return this.bloomOffset;
    }

    @Override
    public float getBloomingEnd() {
        return this.bloomingEnd;
    }

    @Override
    public float getSeedingEnd() {
        return this.seedingEnd;
    }

    @Override
    public float getDyingEnd() {
        return this.dyingEnd;
    }

    @Override
    public float getDormantEnd() {
        return this.dormantEnd;
    }

    @Override
    public float getSproutingEnd() {
        return this.sproutingEnd;
    }

    public boolean needsItem() {
        return !BlockType.NO_ITEM_TYPES.contains((Object)this.type);
    }

    public boolean canBeSnowPiled() {
        return this.type == BlockType.STANDARD || this.type == BlockType.SHORT_GRASS || this.type == BlockType.TALL_GRASS || this.type == BlockType.CREEPING || this.type == BlockType.CREEPING_STONE || this.type == BlockType.BEACH_GRASS;
    }

    public boolean canBeIcePiled() {
        return this.type == BlockType.TALL_WATER || this.type == BlockType.TALL_WATER_FRESH || this.type == BlockType.FLOATING || this.type == BlockType.FLOATING_FRESH;
    }

    public boolean isFoliage() {
        return BlockType.FOLIAGE_TYPES.contains((Object)this.type) || FOLIAGE_COLOR_PLANTS.contains(this);
    }

    public boolean isSeasonal() {
        return this.type == BlockType.VINE;
    }

    public boolean isTallGrass() {
        return (this.type == BlockType.TALL_GRASS || this.type == BlockType.SHORT_GRASS) && !FOLIAGE_COLOR_PLANTS.contains(this);
    }

    public boolean usesWaterTint() {
        return WATER_COLOR_PLANTS.contains(this);
    }

    public boolean isBlockTinted() {
        return BLOCK_TINTED_PLANTS.contains(this);
    }

    public boolean isItemTinted() {
        return ITEM_TINTED_PLANTS.contains(this);
    }

    public boolean isFlowerpotTinted() {
        return FLOWERPOT_TINTED_PLANTS.contains(this);
    }

    public boolean hasFlowerPot() {
        return this.type == BlockType.STANDARD || this.type == BlockType.FLOWERBED || this.type == BlockType.DRY || this.type == BlockType.CACTUS_FLOWER || this.type == BlockType.BAMBOO || SPECIAL_POTTED_PLANTS.contains(this);
    }

    @Override
    @Nullable
    public IntegerProperty getAgeProperty() {
        return this.ageProperty;
    }

    private Supplier<? extends Block> transform() {
        return TFCBlocks.PLANTS.get(switch (this.ordinal()) {
            case 143 -> HANGING_VINES_PLANT;
            case 142 -> HANGING_VINES;
            case 151 -> TREE_FERN_PLANT;
            case 150 -> TREE_FERN;
            case 153 -> CYCAD_PLANT;
            case 152 -> CYCAD;
            case 158 -> WINGED_KELP;
            case 159 -> WINGED_KELP_PLANT;
            case 163 -> GIANT_KELP_PLANT;
            case 161 -> LEAFY_KELP_PLANT;
            case 160 -> LEAFY_KELP;
            case 155 -> ARUNDO_PLANT;
            case 154 -> ARUNDO;
            case 157 -> DRY_PHRAGMITE_PLANT;
            case 156 -> DRY_PHRAGMITE;
            case 147 -> LIANA_PLANT;
            case 146 -> LIANA;
            case 149 -> FLAME_VINE_PLANT;
            case 148 -> FLAME_VINE;
            case 144 -> SPANISH_MOSS;
            case 145 -> SPANISH_MOSS_PLANT;
            case 166 -> SAGUARO;
            case 167 -> SAGUARO_PLANT;
            case 168 -> GOLDEN_BAMBOO_SAPLING;
            case 169 -> GOLDEN_BAMBOO;
            default -> throw new IllegalStateException("Uhh why did you try to transform something that's not a tall plant?");
        });
    }

    private Supplier<? extends Block> secondTransform() {
        if (this == SAGUARO) {
            return TFCBlocks.PLANTS.get(SAGUARO_FRUIT);
        }
        throw new IllegalStateException("Uhh why did you try to transform something that's not a tall plant?");
    }

    static {
        SPECIAL_POTTED_PLANTS = EnumSet.of(BARREL_CACTUS, new Plant[]{FOXGLOVE, MORNING_GLORY, MOSS, OSTRICH_FERN, REINDEER_LICHEN, ROSE, SAPPHIRE_TOWER, TOQUILLA_PALM, TREE_FERN, PHILODENDRON, SHAWIASH, BEAR_GRASS, KINNIKINNICK, AZALEA, ELEGANT_SUNBURST_LICHEN, CYCAD});
        BLOCK_TINTED_PLANTS = EnumSet.of(PAMPAS_GRASS, new Plant[]{BLUEGRASS, BROMEGRASS, FOUNTAIN_GRASS, ORCHARD_GRASS, RYEGRASS, SCUTCH_GRASS, TIMOTHY_GRASS, RADDIA_GRASS, ARROWHEAD, BUR_REED, CATTAIL, DUCKWEED, FIELD_HORSETAIL, GUTWEED, KANGAROO_PAW, KING_FERN, LADY_FERN, LICORICE_FERN, LOTUS, MORNING_GLORY, PHILODENDRON, MOSS, OSTRICH_FERN, PHRAGMITE, PICKERELWEED, PISTIA, SAGO, SEA_LAVENDER, SWITCHGRASS, SWORD_FERN, TALL_FESCUE_GRASS, TOQUILLA_PALM, WHITE_WATER_LILY, YELLOW_WATER_LILY, PURPLE_WATER_LILY, WATER_TARO, HANGING_VINES_PLANT, HANGING_VINES, SPANISH_MOSS_PLANT, SPANISH_MOSS, TREE_FERN_PLANT, TREE_FERN, IVY, JUNGLE_VINES, MAIDEN_PINK, CYCAD, RED_OAT_GRASS, ARUNDO_PLANT, ARUNDO, TANK_BROMELIAD, BUTTERCUP});
        ITEM_TINTED_PLANTS = EnumSet.of(BLUEGRASS, new Plant[]{BROMEGRASS, FOUNTAIN_GRASS, ORCHARD_GRASS, RYEGRASS, SCUTCH_GRASS, TIMOTHY_GRASS, RADDIA_GRASS, KING_FERN, MOSS, SAGO, SWITCHGRASS, TALL_FESCUE_GRASS, IVY, JUNGLE_VINES, HANGING_VINES, GUTWEED, RED_OAT_GRASS});
        FLOWERPOT_TINTED_PLANTS = EnumSet.of(PHILODENDRON, MOSS, TREE_FERN);
        FOLIAGE_COLOR_PLANTS = EnumSet.of(SWORD_FERN, new Plant[]{OSTRICH_FERN, KING_FERN, TOQUILLA_PALM, LADY_FERN, LICORICE_FERN, BIRD_NEST_FERN});
        WATER_COLOR_PLANTS = EnumSet.of(TANK_BROMELIAD);
    }

    static enum BlockType {
        STANDARD((plant, type) -> PlantBlock.create(plant, BlockType.fire(BlockType.nonSolid(plant)).offsetType(BlockBehaviour.OffsetType.XZ))),
        SHORT_SHRUB((plant, type) -> PlantBlock.createShortShrub(plant, BlockType.fire(BlockType.nonSolid(plant)))),
        SHRUB((plant, type) -> PlantBlock.createShrub(plant, BlockType.fire(BlockType.nonSolid(plant)))),
        FLOWERBED((plant, type) -> PlantBlock.createFlowerbed(plant, BlockType.fire(BlockType.nonSolid(plant)))),
        CACTUSBED((plant, type) -> TFCCactusBedBlock.createBarrel(plant, BlockType.fire(BlockType.solid().strength(0.25f).sound(SoundType.WOOL).offsetType(BlockBehaviour.OffsetType.XZ).dynamicShape()))),
        CACTUS_FLOWER((plant, type) -> PlantBlock.createCactusFlower(plant, BlockType.fire(BlockType.nonSolid(plant)).sound(SoundType.CROP))),
        CACTUS((plant, type) -> TFCCactusBlock.create(plant, BlockType.fire(BlockType.solid().strength(0.25f).sound(SoundType.WOOL)).pathType(PathType.DAMAGE_OTHER))),
        PASSABLE_CACTUS((plant, type) -> TFCPassableCactusBlock.create(plant, BlockType.fire(BlockType.nonSolid(plant).strength(0.25f).sound(SoundType.WOOL)).pathType(PathType.DAMAGE_OTHER))),
        DRY((plant, type) -> PlantBlock.createDry(plant, BlockType.fire(BlockType.nonSolid(plant).offsetType(BlockBehaviour.OffsetType.XZ)))),
        CREEPING((plant, type) -> CreepingPlantBlock.create(plant, BlockType.fire(BlockType.nonSolid(plant).hasPostProcess(TFCBlocks::always)))),
        CREEPING_STONE((plant, type) -> CreepingPlantBlock.createStone(plant, BlockType.fire(BlockType.nonSolid(plant).hasPostProcess(TFCBlocks::always)))),
        EPIPHYTE((plant, type) -> EpiphytePlantBlock.create(plant, BlockType.fire(BlockType.nonSolid(plant).hasPostProcess(TFCBlocks::always)))),
        PERCHED_EPIPHYTE((plant, type) -> PlantBlock.createPerchedEpiphyte(plant, BlockType.fire(BlockType.nonSolid(plant)).offsetType(BlockBehaviour.OffsetType.XZ))),
        SHORT_GRASS((plant, type) -> ShortGrassBlock.create(plant, BlockType.fire(BlockType.nonSolid(plant)).offsetType(BlockBehaviour.OffsetType.XZ))),
        BEACH_GRASS((plant, type) -> ShortGrassBlock.createBeachGrass(plant, BlockType.fire(BlockType.nonSolid(plant)).offsetType(BlockBehaviour.OffsetType.XZ))),
        TALL_GRASS((plant, type) -> TFCTallGrassBlock.create(plant, BlockType.fire(BlockType.nonSolid(plant)).offsetType(BlockBehaviour.OffsetType.XZ))),
        TALL_SHRUB((plant, type) -> TFCTallShrubBlock.create(plant, BlockType.fire(BlockType.nonSolid(plant)))),
        VINE((plant, type) -> new TFCVineBlock(BlockType.fire(BlockType.nonSolid(plant)))),
        WEEPING((plant, type) -> new BodyPlantBlock(BlockType.fire(BlockType.nonSolidTallPlant(plant)), plant.transform(), BodyPlantBlock.BODY_SHAPE, Direction.DOWN, (Plant)plant)),
        WEEPING_TOP((plant, type) -> new TopPlantBlock(BlockType.fire(BlockType.nonSolidTallPlant(plant)), plant.transform(), Direction.DOWN, BodyPlantBlock.WEEPING_SHAPE, 20, 26, (Plant)plant)),
        TWISTING((plant, type) -> new BodyPlantBlock(BlockType.fire(BlockType.nonSolidTallPlant(plant)), plant.transform(), BodyPlantBlock.BODY_SHAPE, Direction.UP, (Plant)plant)),
        TWISTING_TOP((plant, type) -> new TopPlantBlock(BlockType.fire(BlockType.nonSolidTallPlant(plant)), plant.transform(), Direction.UP, BodyPlantBlock.TWISTING_SHAPE, 4, 8, (Plant)plant)),
        TWISTING_TOP_SHORT((plant, type) -> new TopPlantBlock(BlockType.fire(BlockType.nonSolidTallPlant(plant)), plant.transform(), Direction.UP, BodyPlantBlock.TWISTING_SHAPE, 2, 4, (Plant)plant)),
        TWISTING_SOLID((plant, type) -> new BodyPlantBlock(BlockType.fire(BlockType.solidTallPlant()), plant.transform(), BodyPlantBlock.BODY_SHAPE, Direction.UP, (Plant)plant)),
        TWISTING_SOLID_TOP((plant, type) -> new TopPlantBlock(BlockType.fire(BlockType.solidTallPlant()), plant.transform(), Direction.UP, BodyPlantBlock.TWISTING_SHAPE, 2, 5, (Plant)plant)),
        BRANCHING_CACTUS((plant, type) -> BranchingCactusBlock.createBody(BlockType.fire(BlockType.solid()).strength(0.25f).sound(SoundType.WOOL).pathType(PathType.DAMAGE_OTHER))),
        BRANCHING_CACTUS_TOP((plant, type) -> GrowingBranchingCactusBlock.createGrowing(BlockType.fire(BlockType.solid()).randomTicks().strength(0.25f).sound(SoundType.WOOL).pathType(PathType.DAMAGE_OTHER), plant.transform(), plant.secondTransform())),
        OCEAN_ROCK_CREEPING((plant, type) -> CreepingWaterPlantBlock.createRock(plant, TFCBlockStateProperties.SALT_WATER, ExtendedProperties.of(BlockType.nonSolid(plant).sound(SoundType.BASALT)))),
        OCEAN_CREEPING((plant, type) -> CreepingWaterPlantBlock.create(plant, TFCBlockStateProperties.SALT_WATER, ExtendedProperties.of(BlockType.nonSolid(plant).sound(SoundType.BASALT)))),
        OCEAN_ROTATABLE((plant, type) -> RotatableWaterPlantBlock.create((RegistryPlant)plant, TFCBlockStateProperties.SALT_WATER, ExtendedProperties.of(BlockType.nonSolid(plant).sound(SoundType.SLIME_BLOCK)))),
        KELP((plant, type) -> TFCKelpBlock.create(BlockType.nonSolidTallPlant(plant).lootFrom(plant.transform()), plant.transform(), Direction.UP, BodyPlantBlock.THIN_BODY_SHAPE, TFCBlockStateProperties.SALT_WATER, plant)),
        KELP_TOP((plant, type) -> TFCKelpTopBlock.create(BlockType.nonSolidTallPlant(plant), plant.transform(), Direction.UP, BodyPlantBlock.TWISTING_THIN_SHAPE, TFCBlockStateProperties.SALT_WATER, plant)),
        KELP_TREE((plant, type) -> KelpTreeBlock.create(ExtendedProperties.of(BlockType.kelp(plant)), TFCBlockStateProperties.SALT_WATER)),
        KELP_TREE_FLOWER((plant, type) -> KelpTreeFlowerBlock.create(BlockType.kelp(plant), plant.transform())),
        FLOATING((plant, type) -> FloatingWaterPlantBlock.create(plant, () -> TFCTags.Fluids.SALT_WATER, BlockType.nonSolid(plant)), PlaceOnWaterBlockItem::new),
        FLOATING_FRESH((plant, type) -> FloatingWaterPlantBlock.create(plant, () -> TFCTags.Fluids.FRESH_WATER, BlockType.nonSolid(plant)), PlaceOnWaterBlockItem::new),
        TALL_WATER((plant, type) -> TallWaterPlantBlock.create(plant, TFCBlockStateProperties.SALT_WATER, BlockType.nonSolid(plant))),
        TALL_WATER_FRESH((plant, type) -> TallWaterPlantBlock.create(plant, TFCBlockStateProperties.FRESH_WATER, BlockType.nonSolid(plant))),
        WATER((plant, type) -> WaterPlantBlock.create(plant, TFCBlockStateProperties.SALT_WATER, BlockType.nonSolid(plant).offsetType(BlockBehaviour.OffsetType.XZ))),
        WATER_FRESH((plant, type) -> WaterPlantBlock.create(plant, TFCBlockStateProperties.FRESH_WATER, BlockType.nonSolid(plant).offsetType(BlockBehaviour.OffsetType.XZ))),
        GRASS_WATER((plant, type) -> TFCSeagrassBlock.create(plant, TFCBlockStateProperties.SALT_WATER, BlockType.nonSolid(plant).offsetType(BlockBehaviour.OffsetType.XZ))),
        GRASS_WATER_FRESH((plant, type) -> TFCSeagrassBlock.create(plant, TFCBlockStateProperties.FRESH_WATER, BlockType.nonSolid(plant).offsetType(BlockBehaviour.OffsetType.XZ))),
        BAMBOO_SAPLING((plant, type) -> new TFCBambooSaplingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_SAPLING), plant.transform())),
        BAMBOO((plant, type) -> new TFCBambooStalkBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO), plant.transform()));

        private static final EnumSet<BlockType> NO_ITEM_TYPES;
        private static final EnumSet<BlockType> FOLIAGE_TYPES;
        private final BiFunction<Plant, BlockType, ? extends Block> factory;
        private final BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory;

        private static BlockBehaviour.Properties solid() {
            return BlockBehaviour.Properties.of().instabreak().noOcclusion().sound(SoundType.GRASS).randomTicks().pushReaction(PushReaction.DESTROY);
        }

        private static BlockBehaviour.Properties nonSolid(Plant plant) {
            return BlockType.solid().replaceable().instabreak().speedFactor(plant.speedFactor).noCollission();
        }

        private static BlockBehaviour.Properties solidTallPlant() {
            return BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).instabreak().noOcclusion().randomTicks().sound(SoundType.WEEPING_VINES).pushReaction(PushReaction.DESTROY);
        }

        private static BlockBehaviour.Properties nonSolidTallPlant(Plant plant) {
            return BlockType.solidTallPlant().instabreak().noCollission().speedFactor(plant.speedFactor).pushReaction(PushReaction.DESTROY);
        }

        private static BlockBehaviour.Properties kelp(Plant plant) {
            return BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().randomTicks().speedFactor(plant.speedFactor).strength(1.0f).sound(SoundType.WET_GRASS).pushReaction(PushReaction.DESTROY);
        }

        private static ExtendedProperties fire(BlockBehaviour.Properties properties) {
            return ExtendedProperties.of(properties).flammable(60, 30);
        }

        private BlockType(BiFunction<Plant, BlockType, ? extends Block> factory) {
            this(factory, BlockItem::new);
        }

        private BlockType(BiFunction<Plant, BlockType, ? extends Block> factory, BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory) {
            this.factory = factory;
            this.blockItemFactory = blockItemFactory;
        }

        static {
            NO_ITEM_TYPES = EnumSet.of(WEEPING, new BlockType[]{TWISTING_SOLID, KELP, KELP_TREE, TWISTING, BRANCHING_CACTUS, BAMBOO_SAPLING});
            FOLIAGE_TYPES = EnumSet.of(WEEPING, new BlockType[]{WEEPING_TOP, FLOATING_FRESH, FLOATING, WATER_FRESH, GRASS_WATER_FRESH, GRASS_WATER, TWISTING, TWISTING_TOP, TWISTING_SOLID, TWISTING_SOLID_TOP});
        }
    }
}

