/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.ISpecialPile;
import net.dries007.tfc.common.blocks.plant.PlantBlock;
import net.dries007.tfc.common.blocks.plant.PlantRegrowth;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;

public abstract class ShortGrassBlock
extends PlantBlock
implements ISpecialPile {
    protected static final VoxelShape GRASS_SHAPE = ShortGrassBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHORTER_GRASS_SHAPE = ShortGrassBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    protected static final VoxelShape SHORT_GRASS_SHAPE = ShortGrassBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    protected static final VoxelShape SHORTEST_GRASS_SHAPE = ShortGrassBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);

    public static ShortGrassBlock create(final RegistryPlant plant, ExtendedProperties properties) {
        return new ShortGrassBlock(properties){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }
        };
    }

    public static ShortGrassBlock createBeachGrass(final RegistryPlant plant, ExtendedProperties properties) {
        return new ShortGrassBlock(properties){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }

            @Override
            protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
                return Helpers.isBlock(state.getBlock(), (TagKey<Block>)BlockTags.SAND) || Helpers.isBlock(state.getBlock(), (TagKey<Block>)Tags.Blocks.SANDS);
            }
        };
    }

    protected ShortGrassBlock(ExtendedProperties properties) {
        super(properties);
    }

    @Override
    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos newPos;
        super.randomTick(state, level, pos, random);
        if (PlantRegrowth.canSpread((Level)level, random, pos) && (newPos = PlantRegrowth.spreadSelf(state, level, pos, random, 2, 2, 4)) != null) {
            level.setBlockAndUpdate(newPos, Helpers.setProperty(state, AGE, 0));
        }
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.getValue((Property)AGE)) {
            case 0 -> SHORTEST_GRASS_SHAPE;
            case 1 -> SHORTER_GRASS_SHAPE;
            case 2 -> SHORT_GRASS_SHAPE;
            default -> GRASS_SHAPE;
        };
    }

    @Override
    public BlockState getHiddenState(BlockState internalState, boolean byPlayer) {
        return (BlockState)internalState.setValue((Property)AGE, (Comparable)Integer.valueOf(0));
    }

    @Override
    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return Helpers.isBlock(state.getBlock(), TFCTags.Blocks.GRASS_PLANTABLE_ON);
    }
}

