/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import java.util.function.Supplier;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BambooSaplingBlock;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.block.state.properties.Property;

public class TFCBambooSaplingBlock
extends BambooSaplingBlock {
    private final Supplier<? extends Block> stalk;

    public TFCBambooSaplingBlock(BlockBehaviour.Properties properties, Supplier<? extends Block> stalk) {
        super(properties);
        this.stalk = stalk;
    }

    protected void growBamboo(Level level, BlockPos state) {
        level.setBlock(state.above(), (BlockState)this.stalk.get().defaultBlockState().setValue((Property)BambooStalkBlock.LEAVES, (Comparable)BambooLeaves.SMALL), 3);
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (!state.canSurvive((LevelReader)level, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (facing == Direction.UP && Helpers.isBlock(facingState, this.stalk.get())) {
            level.setBlock(currentPos, this.stalk.get().defaultBlockState(), 2);
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.stalk.get());
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return false;
    }
}

