/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import javax.annotation.Nullable;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.PlantBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class TFCCactusBedBlock
extends PlantBlock {
    public static final IntegerProperty AGE = TFCBlockStateProperties.AGE_3;

    public static TFCCactusBedBlock createBarrel(final RegistryPlant plant, ExtendedProperties properties) {
        return new TFCCactusBedBlock(properties){
            static final VoxelShape SHAPE = 1.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }

            @Override
            public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
                return SHAPE;
            }
        };
    }

    protected TFCCactusBedBlock(ExtendedProperties properties) {
        super(properties);
    }

    @Override
    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.setWithOffset((Vec3i)pos, 0, -1, 0);
        BlockState belowState = level.getBlockState((BlockPos)mutable);
        return Helpers.isBlock(belowState, TFCTags.Blocks.DRY_PLANT_PLANTABLE_ON);
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        entity.hurt(entity.damageSources().cactus(), 1.0f);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return !useContext.isSecondaryUseActive() && useContext.getItemInHand().is(this.asItem()) && (Integer)state.getValue((Property)AGE) < 3 || super.canBeReplaced(state, useContext);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        if (Helpers.isBlock(state, (Block)this)) {
            return (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(Math.min(3, (Integer)state.getValue((Property)AGE) + 1)));
        }
        return super.getStateForPlacement(context);
    }
}

