/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.plant.ITallPlant;
import net.dries007.tfc.common.blocks.plant.TFCTallGrassBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class TFCCactusBlock
extends TFCTallGrassBlock {
    protected static final VoxelShape COLLISION_SHAPE = TFCCactusBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    protected static final VoxelShape OUTLINE_SHAPE = TFCCactusBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public static TFCCactusBlock create(final RegistryPlant plant, ExtendedProperties properties) {
        return new TFCCactusBlock(properties){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }
        };
    }

    protected TFCCactusBlock(ExtendedProperties properties) {
        super(properties);
    }

    @Override
    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            mutable.setWithOffset((Vec3i)pos, direction);
            BlockState stateAt = level.getBlockState((BlockPos)mutable);
            if (!stateAt.isSolid() && !Helpers.isFluid(level.getFluidState((BlockPos)mutable), TFCTags.Fluids.LAVA_LIKE)) continue;
            return false;
        }
        mutable.setWithOffset((Vec3i)pos, 0, -1, 0);
        BlockState belowState = level.getBlockState((BlockPos)mutable);
        if (state.getValue((Property)PART) == ITallPlant.Part.LOWER) {
            return Helpers.isBlock(belowState, TFCTags.Blocks.DRY_PLANT_PLANTABLE_ON);
        }
        if (state.getBlock() != this) {
            return Helpers.isBlock(belowState, TFCTags.Blocks.DRY_PLANT_PLANTABLE_ON);
        }
        return belowState.getBlock() == this && belowState.getValue((Property)PART) == ITallPlant.Part.LOWER;
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return OUTLINE_SHAPE;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPE;
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        entity.hurt(entity.damageSources().cactus(), 1.0f);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

