/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.plant.Plant;
import net.dries007.tfc.common.blocks.plant.TopPlantBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantBodyBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class TFCKelpTopBlock
extends TopPlantBlock
implements IFluidLoggable {
    private final Supplier<? extends Block> bodyBlock;

    public static TFCKelpTopBlock create(BlockBehaviour.Properties properties, Supplier<? extends Block> bodyBlock, Direction direction, VoxelShape shape, final FluidProperty fluid, Plant plant) {
        return new TFCKelpTopBlock(ExtendedProperties.of(properties), bodyBlock, direction, shape, plant){

            @Override
            public FluidProperty getFluidProperty() {
                return fluid;
            }
        };
    }

    protected TFCKelpTopBlock(ExtendedProperties properties, Supplier<? extends Block> bodyBlock, Direction direction, VoxelShape shape, Plant plant) {
        super(properties, bodyBlock, direction, shape, 18, 26, plant);
        this.bodyBlock = bodyBlock;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState;
        Level level = context.getLevel();
        BlockState state = super.getStateForPlacement(context);
        if (state != null && !(fluidState = level.getFluidState(context.getClickedPos())).isEmpty() && this.getFluidProperty().canContain(fluidState.getType())) {
            return (BlockState)state.setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(fluidState.getType()));
        }
        return null;
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (state.getFluidState().isEmpty()) {
            return false;
        }
        return super.canSurvive(state, level, pos);
    }

    protected boolean canAttachTo(BlockState state) {
        return state.getBlock() != Blocks.MAGMA_BLOCK;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape voxelshape = super.getShape(state, level, pos, context);
        Vec3 vector3d = state.getOffset(level, pos);
        return voxelshape.move(vector3d.x, vector3d.y, vector3d.z);
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing == this.growthDirection.getOpposite() && !state.canSurvive((LevelReader)level, currentPos)) {
            level.scheduleTick(currentPos, (Block)this, 1);
        }
        if (facing != this.growthDirection || !Helpers.isBlock(facingState, (Block)this) && !Helpers.isBlock(facingState, (Block)this.getBodyBlock())) {
            FluidHelpers.tickFluid(level, currentPos, state);
            return state;
        }
        return (BlockState)this.getBodyBlock().defaultBlockState().setValue((Property)this.getFluidProperty(), (Comparable)((FluidProperty.FluidKey)state.getValue((Property)this.getFluidProperty())));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{this.getFluidProperty()});
    }

    @Override
    public FluidState getFluidState(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }

    @Override
    protected boolean canGrowInto(BlockState state) {
        Fluid fluid = state.getFluidState().getType();
        return this.getFluidProperty().canContain(fluid) && fluid != Fluids.EMPTY;
    }

    protected GrowingPlantBodyBlock getBodyBlock() {
        return (GrowingPlantBodyBlock)this.bodyBlock.get();
    }
}

