/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.plant.Plant;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.NetherVines;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.Nullable;

public class TopPlantBlock
extends GrowingPlantHeadBlock
implements IForgeBlockExtension {
    protected static final float AABB_OFFSET = 3.0f;
    private final Supplier<? extends Block> bodyBlock;
    private final ExtendedProperties properties;
    private final int minHeight;
    private final int maxHeight;
    private final Plant plant;

    public TopPlantBlock(ExtendedProperties properties, Supplier<? extends Block> bodyBlock, Direction direction, VoxelShape shape, int minHeight, int maxHeight, Plant plant) {
        super(properties.properties().dynamicShape().offsetType(BlockBehaviour.OffsetType.XZ), direction, shape, false, 0.0);
        this.bodyBlock = bodyBlock;
        this.properties = properties;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.plant = plant;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos blockpos;
        if ((Integer)state.getValue((Property)AGE) < 25 && CommonHooks.canCropGrow((Level)level, (BlockPos)pos.relative(this.growthDirection), (BlockState)level.getBlockState(pos.relative(this.growthDirection)), (random.nextDouble() < TFCConfig.SERVER.plantLongGrowthChance.get() ? 1 : 0) != 0) && this.canGrowInto(level.getBlockState(blockpos = pos.relative(this.growthDirection)))) {
            level.setBlockAndUpdate(blockpos, (BlockState)state.cycle((Property)AGE));
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)blockpos, (BlockState)level.getBlockState(blockpos));
        }
    }

    protected int getBlocksToGrowWhenBonemealed(RandomSource source) {
        return 0;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        BlockState belowState = context.getLevel().getBlockState(context.getClickedPos().relative(this.growthDirection.getOpposite()));
        return state == null ? null : (belowState.getBlock() == this ? (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(Math.min((Integer)belowState.getValue((Property)AGE) + 1, 25))) : (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(Mth.nextInt((RandomSource)context.getLevel().getRandom(), (int)(26 - this.maxHeight), (int)(26 - this.minHeight)))));
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    protected boolean canGrowInto(BlockState state) {
        return NetherVines.isValidGrowthState((BlockState)state);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos relPos = pos.relative(this.growthDirection.getOpposite());
        BlockState relState = level.getBlockState(relPos);
        Block block = relState.getBlock();
        if (!this.canAttachTo(relState)) {
            return false;
        }
        return block == this.getHeadBlock() || block == this.getBodyBlock() || Helpers.isBlock(relState, (TagKey<Block>)BlockTags.LEAVES) || relState.isFaceSturdy((BlockGetter)level, relPos, this.growthDirection);
    }

    protected Block getBodyBlock() {
        return this.bodyBlock.get();
    }

    protected MapCodec<? extends GrowingPlantHeadBlock> codec() {
        return this.fakeBlockCodec();
    }

    public RegistryPlant getPlant() {
        return this.plant;
    }
}

