/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.coral;

import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.plant.coral.CoralWallFanBlock;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class LivingCoralWallFanBlock
extends CoralWallFanBlock {
    private final Supplier<? extends Block> deadBlock;

    public LivingCoralWallFanBlock(Supplier<? extends Block> deadBlock, BlockBehaviour.Properties builder) {
        super(builder);
        this.deadBlock = deadBlock;
    }

    protected void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.tryScheduleDieTick(state, (LevelAccessor)worldIn, pos);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!this.scanForWater(state, (BlockGetter)level, pos)) {
            level.setBlock(pos, (BlockState)((BlockState)this.deadBlock.get().defaultBlockState().setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(Fluids.EMPTY))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))), 2);
        }
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing.getOpposite() == state.getValue((Property)FACING) && !state.canSurvive((LevelReader)level, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (((FluidProperty.FluidKey)state.getValue((Property)this.getFluidProperty())).getFluid() == TFCFluids.SALT_WATER.getSource()) {
            level.scheduleTick(currentPos, (Fluid)TFCFluids.SALT_WATER.getSource(), TFCFluids.SALT_WATER.getSource().getTickDelay((LevelReader)level));
        }
        this.tryScheduleDieTick(state, level, currentPos);
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }
}

