/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.coral;

import net.dries007.tfc.common.TFCDamageTypes;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.entities.aquatic.AmphibiousAnimal;
import net.dries007.tfc.common.entities.aquatic.AquaticMob;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TFCCoralPlantBlock
extends Block
implements IFluidLoggable {
    public static final FluidProperty FLUID = TFCBlockStateProperties.SALT_WATER;
    public static final VoxelShape SMALL_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    public static final VoxelShape BIG_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);
    private final VoxelShape shape;

    public TFCCoralPlantBlock(VoxelShape shape, BlockBehaviour.Properties properties) {
        super(properties);
        this.shape = shape;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluid = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyForOrEmpty(fluid.getType()));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{this.getFluidProperty()}));
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        return facing == Direction.DOWN && !this.canSurvive(state, (LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    @Override
    public FluidState getFluidState(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos posBelow = pos.below();
        return level.getBlockState(posBelow).isFaceSturdy((BlockGetter)level, posBelow, Direction.UP);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!(entity instanceof AquaticMob) && !(entity instanceof AmphibiousAnimal)) {
            TFCDamageTypes.coral(entity, 0.5f);
        }
    }

    @Override
    public FluidProperty getFluidProperty() {
        return FLUID;
    }

    protected void tryScheduleDieTick(BlockState state, LevelAccessor level, BlockPos pos) {
        if (!this.scanForWater(state, (BlockGetter)level, pos)) {
            level.scheduleTick(pos, (Block)this, 60 + level.getRandom().nextInt(40));
        }
    }

    protected boolean scanForWater(BlockState state, BlockGetter level, BlockPos pos) {
        if (Helpers.isFluid(((FluidProperty.FluidKey)state.getValue((Property)this.getFluidProperty())).getFluid(), TFCTags.Fluids.ANY_INFINITE_WATER)) {
            return true;
        }
        for (Direction direction : Helpers.DIRECTIONS) {
            if (!Helpers.isFluid(level.getFluidState(pos.relative(direction)), TFCTags.Fluids.ANY_INFINITE_WATER)) continue;
            return true;
        }
        return false;
    }
}

