/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.BerryBushBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.plant.fruit.IBushBlock;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.blocks.plant.fruit.SeasonalPlantBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateRange;
import net.dries007.tfc.util.climate.ClimateRanges;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BananaPlantBlock
extends SeasonalPlantBlock
implements IBushBlock,
HoeOverlayBlock {
    public static final VoxelShape PLANT = BananaPlantBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);
    private static final VoxelShape TRUNK_0 = BananaPlantBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape TRUNK_1 = BananaPlantBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);

    public static void kill(Level level, BlockPos pos) {
        Block deadBlock = (Block)TFCBlocks.DEAD_BANANA_PLANT.get();
        if (!level.isClientSide) {
            BlockState foundState;
            BlockState deadState = deadBlock.defaultBlockState();
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set((Vec3i)pos.below());
            while (Helpers.isBlock(foundState = level.getBlockState((BlockPos)mutable), (Block)TFCBlocks.BANANA_PLANT.get())) {
                level.setBlockAndUpdate((BlockPos)mutable, (BlockState)deadState.setValue((Property)STAGE, (Comparable)((Integer)foundState.getValue((Property)STAGE))));
                mutable.move(Direction.DOWN);
            }
        }
    }

    public BananaPlantBlock(ExtendedProperties properties, Supplier<? extends Item> productItem, Lifecycle[] stages) {
        super(properties, ClimateRanges.BANANA_PLANT, productItem, stages);
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemInteractionResult result = super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        if (result.consumesAction()) {
            BananaPlantBlock.kill(level, pos);
        }
        return result;
    }

    @Override
    public BlockState stateAfterPicking(BlockState state) {
        return (BlockState)((Block)TFCBlocks.DEAD_BANANA_PLANT.get()).defaultBlockState().setValue((Property)STAGE, (Comparable)Integer.valueOf(2));
    }

    @Override
    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, Consumer<Component> text, boolean isDebug) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BerryBushBlockEntity) {
            BerryBushBlockEntity bush = (BerryBushBlockEntity)blockEntity;
            ClimateRange range = (ClimateRange)this.climateRange.get();
            BlockPos sourcePos = bush.getStemPos().below();
            int hydration = BananaPlantBlock.getFruitBushHydration(level, pos);
            text.accept(FarmlandBlock.getHydrationTooltip(range, false, hydration));
            text.accept(FarmlandBlock.getAverageTemperatureTooltip(level, sourcePos, range, false));
        }
    }

    @Override
    public ItemStack getProductItem(RandomSource random) {
        return new ItemStack((ItemLike)this.productItem.get(), Mth.nextInt((RandomSource)random, (int)3, (int)6));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.getValue((Property)STAGE)) {
            case 0 -> TRUNK_0;
            case 1 -> TRUNK_1;
            default -> PLANT;
        };
    }

    @Override
    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Integer)state.getValue((Property)STAGE) == 2 ? Shapes.empty() : this.getShape(state, level, pos, context);
    }

    @Override
    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
    }

    @Override
    public void onUpdate(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BerryBushBlockEntity) {
            Lifecycle expectedLifecycle;
            BerryBushBlockEntity bush = (BerryBushBlockEntity)blockEntity;
            Lifecycle currentLifecycle = (Lifecycle)((Object)state.getValue((Property)LIFECYCLE));
            if (!BananaPlantBlock.checkAndSetDormant(level, pos, state, currentLifecycle, expectedLifecycle = this.getLifecycleForCurrentMonth(level, pos))) {
                BlockState newState;
                long deltaTicks = Math.min(bush.getTicksSinceBushUpdate(), Calendars.SERVER.getCalendarTicksInYear());
                long currentCalendarTick = Calendars.SERVER.getCalendarTicks();
                long nextCalendarTick = currentCalendarTick - deltaTicks;
                BlockPos stemPos = bush.getStemPos();
                float temperature = Climate.getAverageTemperature(level, stemPos);
                int hydration = BananaPlantBlock.getFruitBushHydrationFromRootPos(level, stemPos.below());
                ClimateRange range = (ClimateRange)this.climateRange.get();
                int stage = (Integer)state.getValue((Property)STAGE);
                BlockPos abovePos = pos.above();
                do {
                    nextCalendarTick = Math.min(nextCalendarTick + Calendars.SERVER.getCalendarTicksInMonth(), currentCalendarTick);
                    if (currentLifecycle.active() && stage < 2) {
                        BlockPos downPos = pos.below(3);
                        if (!Helpers.isBlock(level.getBlockState(abovePos), (Block)this) && (level.random.nextInt(4) == 0 || Helpers.isBlock(level.getBlockState(downPos), (Block)this))) {
                            ++stage;
                        }
                    }
                    Lifecycle lifecycleAtNextTick = this.getLifecycleForMonth(ICalendar.getMonthOfYear(nextCalendarTick, Calendars.SERVER.getCalendarDaysInMonth()));
                    currentLifecycle = range.checkBoth(hydration, temperature, false) ? currentLifecycle.advanceTowards(lifecycleAtNextTick) : Lifecycle.DORMANT;
                    if (stage < 2 && currentLifecycle.active()) {
                        currentLifecycle = Lifecycle.HEALTHY;
                    }
                    newState = (BlockState)((BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(stage))).setValue((Property)LIFECYCLE, (Comparable)((Object)currentLifecycle));
                    if (stage >= 2 || !currentLifecycle.active() || !level.isEmptyBlock(abovePos) || !level.canSeeSky(abovePos)) continue;
                    level.setBlockAndUpdate(abovePos, newState);
                    long newBushTicks = nextCalendarTick;
                    level.getBlockEntity(abovePos, (BlockEntityType)TFCBlockEntities.BERRY_BUSH.get()).ifPresent(newBush -> {
                        newBush.setLastBushTick(newBushTicks);
                        newBush.setStemPos(stemPos);
                    });
                } while (nextCalendarTick < currentCalendarTick);
                if (state != newState) {
                    level.setBlockAndUpdate(pos, newState);
                }
            }
        }
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if ((Integer)state.getValue((Property)STAGE) == 2 && newState.isAir()) {
            BananaPlantBlock.kill(level, pos);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowPos = pos.below();
        BlockState belowState = level.getBlockState(belowPos);
        return Helpers.isBlock(belowState, TFCTags.Blocks.BUSH_PLANTABLE_ON) || Helpers.isBlock(belowState, (Block)this);
    }
}

