/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TickCountingBranchBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.PipePlantBlock;
import net.dries007.tfc.common.blocks.plant.fruit.FruitTreeSaplingBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class FruitTreeBranchBlock
extends PipePlantBlock
implements HoeOverlayBlock {
    public static final IntegerProperty STAGE = TFCBlockStateProperties.STAGE_3;
    private final Supplier<ClimateRange> climateRange;

    public FruitTreeBranchBlock(ExtendedProperties properties, Supplier<ClimateRange> climateRange) {
        super(0.25f, properties);
        this.climateRange = climateRange;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, Consumer<Component> text, boolean isDebug) {
        ClimateRange range = this.climateRange.get();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TickCountingBranchBlockEntity) {
            TickCountingBranchBlockEntity branch = (TickCountingBranchBlockEntity)blockEntity;
            BlockPos rootPos = branch.getStemPos().below();
            text.accept(FarmlandBlock.getHydrationTooltip(level, rootPos, range, false));
            text.accept(FarmlandBlock.getAverageTemperatureTooltip(level, rootPos, range, false));
        } else {
            text.accept((Component)Component.translatable((String)"tfc.tooltip.fruit_tree.check_leaves"));
        }
        if (FruitTreeSaplingBlock.maySplice(level, pos.above(), level.getBlockState(pos.above()))) {
            text.accept((Component)Component.translatable((String)"tfc.tooltip.fruit_tree.sapling_splice"));
        }
        this.addExtraInfo(text);
    }

    public void addExtraInfo(Consumer<Component> text) {
        text.accept((Component)Component.translatable((String)"tfc.tooltip.fruit_tree.done_growing"));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{STAGE}));
    }

    @Override
    protected boolean testDown(BlockState state) {
        return Helpers.isBlock(state, TFCTags.Blocks.FRUIT_TREE_BRANCH) || Helpers.isBlock(state, TFCTags.Blocks.BUSH_PLANTABLE_ON);
    }

    @Override
    protected boolean testUp(BlockState state) {
        return Helpers.isBlock(state, TFCTags.Blocks.FRUIT_TREE_BRANCH) || Helpers.isBlock(state, TFCTags.Blocks.FRUIT_TREE_SAPLING);
    }

    @Override
    protected boolean testHorizontal(BlockState state) {
        return Helpers.isBlock(state, TFCTags.Blocks.FRUIT_TREE_BRANCH);
    }

    @Override
    protected boolean canGrowLongSideways() {
        return true;
    }
}

