/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.BerryBushBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.fruit.IBushBlock;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.blocks.plant.fruit.SeasonalPlantBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.common.blocks.wood.ILeavesBlock;
import net.dries007.tfc.common.blocks.wood.TFCLeavesBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FruitTreeLeavesBlock
extends SeasonalPlantBlock
implements IForgeBlockExtension,
ILeavesBlock,
IBushBlock,
HoeOverlayBlock,
IFluidLoggable {
    public static final BooleanProperty PERSISTENT = BlockStateProperties.PERSISTENT;
    public static final EnumProperty<Lifecycle> LIFECYCLE = TFCBlockStateProperties.LIFECYCLE;
    public static final FluidProperty FLUID = TFCBlockStateProperties.WATER;
    private final int flowerColor;

    public static MapColor getMapColor(BlockState state) {
        return switch ((Lifecycle)((Object)state.getValue(LIFECYCLE))) {
            case Lifecycle.DORMANT -> MapColor.COLOR_BROWN;
            case Lifecycle.FLOWERING -> MapColor.COLOR_PINK;
            default -> MapColor.PLANT;
        };
    }

    public FruitTreeLeavesBlock(ExtendedProperties properties, Supplier<? extends Item> productItem, Lifecycle[] stages, Supplier<ClimateRange> climateRange, int flowerColor) {
        super(properties, climateRange, productItem, stages);
        this.flowerColor = flowerColor;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).setValue(LIFECYCLE, (Comparable)((Object)Lifecycle.HEALTHY)));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.block();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluid = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(context.getPlayer() != null))).setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyForOrEmpty(fluid.getType()));
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockState belowState;
        if (state.getValue(LIFECYCLE) == Lifecycle.FLOWERING && random.nextInt(10) == 0 && (belowState = level.getBlockState(pos.below())).isAir()) {
            BlockState aboveState = level.getBlockState(pos.above());
            Object particle = Helpers.isBlock(aboveState, (TagKey<Block>)BlockTags.SNOW) && random.nextBoolean() ? (ParticleOptions)TFCParticles.SNOWFLAKE.get() : new BlockParticleOption((ParticleType)TFCParticles.FALLING_LEAF.get(), state);
            ParticleUtils.spawnParticleBelow((Level)level, (BlockPos)pos, (RandomSource)random, (ParticleOptions)particle);
        }
        TFCLeavesBlock.dripRainwater(level, pos, random);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        IBushBlock.randomTick(this, state, level, pos, random);
    }

    @Override
    public void onUpdate(Level level, BlockPos pos, BlockState state) {
        if (((Boolean)state.getValue((Property)PERSISTENT)).booleanValue()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BerryBushBlockEntity) {
            int hydration;
            ClimateRange range;
            BlockState newState;
            Lifecycle expectedLifecycle;
            BerryBushBlockEntity leaves = (BerryBushBlockEntity)blockEntity;
            BlockPos stemPos = leaves.getStemPos();
            Lifecycle currentLifecycle = (Lifecycle)((Object)state.getValue(LIFECYCLE));
            if (!FruitTreeLeavesBlock.checkAndSetDormant(level, pos, state, currentLifecycle, expectedLifecycle = this.getLifecycleForCurrentMonth(level, pos)) && state != (newState = (BlockState)state.setValue(LIFECYCLE, (Comparable)((Object)(currentLifecycle = (range = (ClimateRange)this.climateRange.get()).checkBoth(hydration = FruitTreeLeavesBlock.getFruitBushHydrationFromRootPos(level, stemPos.below()), Climate.getAverageTemperature(level, stemPos), false) ? currentLifecycle.advanceTowards(expectedLifecycle) : Lifecycle.DORMANT))))) {
                level.setBlock(pos, newState, 3);
            }
        }
    }

    @Override
    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        TFCLeavesBlock.onEntityInside(level, entity);
    }

    @Override
    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, Consumer<Component> text, boolean isDebug) {
        BlockPos stemPos;
        ClimateRange range = (ClimateRange)this.climateRange.get();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BerryBushBlockEntity) {
            BerryBushBlockEntity bush = (BerryBushBlockEntity)blockEntity;
            stemPos = bush.getStemPos();
        } else {
            stemPos = pos;
        }
        text.accept(FarmlandBlock.getHydrationTooltip(range, false, FruitTreeLeavesBlock.getFruitBushHydrationFromRootPos(level, stemPos.below())));
        text.accept(FarmlandBlock.getAverageTemperatureTooltip(level, stemPos, range, false));
    }

    @Override
    public FluidProperty getFluidProperty() {
        return FLUID;
    }

    public int getFlowerColor() {
        return this.flowerColor;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIFECYCLE, PERSISTENT, this.getFluidProperty()});
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        if (this.isValid(level, currentPos, state)) {
            return state;
        }
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            TFCLeavesBlock.doParticles(server, (float)currentPos.getX() + level.getRandom().nextFloat(), (float)currentPos.getY() + level.getRandom().nextFloat(), (float)currentPos.getZ() + level.getRandom().nextFloat(), 1);
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Override
    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    protected int getLightBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return 1;
    }

    protected float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 0.2f;
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!this.isValid((LevelAccessor)level, pos, state)) {
            level.destroyBlock(pos, true);
            TFCLeavesBlock.doParticles(level, (float)pos.getX() + rand.nextFloat(), (float)pos.getY() + rand.nextFloat(), (float)pos.getZ() + rand.nextFloat(), 1);
        }
    }

    @Override
    public FluidState getFluidState(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }

    private boolean isValid(LevelAccessor level, BlockPos pos, BlockState state) {
        if (((Boolean)state.getValue((Property)PERSISTENT)).booleanValue()) {
            return true;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction direction : Helpers.DIRECTIONS) {
            mutablePos.set((Vec3i)pos).move(direction);
            if (!Helpers.isBlock(level.getBlockState((BlockPos)mutablePos), TFCTags.Blocks.FRUIT_TREE_BRANCH)) continue;
            return true;
        }
        return false;
    }
}

