/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import com.mojang.serialization.MapCodec;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.dries007.tfc.client.overworld.SolarCalculator;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TickCountingBranchBlockEntity;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.plant.Plant;
import net.dries007.tfc.common.blocks.plant.fruit.FruitTreeBranchBlock;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.blocks.plant.fruit.SeasonalPlantBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.Nullable;

public class FruitTreeSaplingBlock
extends BushBlock
implements IForgeBlockExtension,
EntityBlockExtension,
HoeOverlayBlock {
    private static final IntegerProperty SAPLINGS = TFCBlockStateProperties.SAPLINGS;
    protected final Supplier<? extends Block> block;
    private final Supplier<Integer> ticksToGrow;
    private final ExtendedProperties properties;
    private final Supplier<ClimateRange> climateRange;
    private final Lifecycle[] stages;

    public static boolean maySplice(Level level, BlockPos pos, BlockState state) {
        BlockState below = level.getBlockState(pos.below());
        if (state.hasProperty((Property)SAPLINGS)) {
            int saplings = (Integer)state.getValue((Property)SAPLINGS);
            return Helpers.isBlock(below, TFCTags.Blocks.FRUIT_TREE_BRANCH) ? saplings < 3 : saplings < 4;
        }
        return Helpers.isBlock(below, TFCTags.Blocks.FRUIT_TREE_BRANCH) && state.isAir();
    }

    public FruitTreeSaplingBlock(ExtendedProperties properties, Supplier<? extends Block> block, Supplier<Integer> ticksToGrow, Supplier<ClimateRange> climateRange, Lifecycle[] stages) {
        super(properties.properties());
        this.properties = properties;
        this.block = block;
        this.ticksToGrow = ticksToGrow;
        this.climateRange = climateRange;
        this.stages = stages;
    }

    @Override
    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, Consumer<Component> text, boolean isDebug) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TickCountingBranchBlockEntity) {
            TickCountingBranchBlockEntity sapling = (TickCountingBranchBlockEntity)blockEntity;
            ClimateRange range = this.climateRange.get();
            BlockPos stemPos = sapling.getStemPos();
            text.accept(FarmlandBlock.getHydrationTooltip(range, false, SeasonalPlantBlock.getFruitBushHydrationFromRootPos(level, stemPos.below())));
            text.accept(FarmlandBlock.getAverageTemperatureTooltip(level, stemPos, range, false));
            if (!this.stages[Calendars.SERVER.getHemispheralCalendarMonthOfYear(SolarCalculator.getInNorthernHemisphere(pos, level)).ordinal()].active()) {
                text.accept((Component)Component.translatable((String)"tfc.tooltip.fruit_tree.sapling_wrong_month"));
            } else {
                text.accept((Component)Component.translatable((String)"tfc.tooltip.fruit_tree.growing"));
            }
            if (FruitTreeSaplingBlock.maySplice(level, pos, state)) {
                text.accept((Component)Component.translatable((String)"tfc.tooltip.fruit_tree.sapling_splice"));
            }
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        int saplings = (Integer)state.getValue((Property)SAPLINGS);
        ItemStack held = player.getItemInHand(InteractionHand.MAIN_HAND);
        ItemStack off = player.getItemInHand(InteractionHand.OFF_HAND);
        if (this.defaultBlockState().getBlock().asItem() == held.getItem() && Helpers.isItem(off, TFCTags.Items.TOOLS_KNIFE) && FruitTreeSaplingBlock.maySplice(level, pos, state)) {
            if (!player.isCreative()) {
                held.shrink(1);
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)SAPLINGS, (Comparable)Integer.valueOf(saplings + 1)));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SeasonalPlantBlock.PLANT_SHAPE;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        TickCountingBranchBlockEntity counter;
        long elapsedTicks;
        BlockEntity blockEntity;
        if (this.stages[Calendars.SERVER.getHemispheralCalendarMonthOfYear(SolarCalculator.getInNorthernHemisphere(pos, (Level)level)).ordinal()].active() && (blockEntity = level.getBlockEntity(pos)) instanceof TickCountingBranchBlockEntity && (elapsedTicks = (counter = (TickCountingBranchBlockEntity)blockEntity).getTicksSinceUpdate()) > this.getTicksToGrow()) {
            BlockPos stemPos = counter.getStemPos();
            int hydration = SeasonalPlantBlock.getFruitBushHydrationFromRootPos((Level)level, stemPos.below());
            float temp = Climate.getAverageTemperature((Level)level, stemPos);
            if (!this.climateRange.get().checkBoth(hydration, temp, false)) {
                level.setBlockAndUpdate(pos, ((Block)TFCBlocks.PLANTS.get(Plant.DEAD_BUSH).get()).defaultBlockState());
            } else {
                this.createTree((Level)level, pos, state, random, elapsedTicks - this.getTicksToGrow(), stemPos);
            }
        }
    }

    public void createTree(Level level, BlockPos pos, BlockState state, RandomSource random, long ticksToAdd, BlockPos stemPos) {
        int internalSapling;
        boolean onBranch = Helpers.isBlock(level.getBlockState(pos.below()), TFCTags.Blocks.FRUIT_TREE_BRANCH);
        int n = internalSapling = onBranch ? 3 : (Integer)state.getValue((Property)SAPLINGS);
        if (internalSapling == 1 && random.nextBoolean()) {
            ++internalSapling;
        }
        level.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)this.block.get().defaultBlockState().setValue((Property)PipeBlock.DOWN, (Comparable)Boolean.valueOf(true))).setValue((Property)TFCBlockStateProperties.SAPLINGS, (Comparable)Integer.valueOf(internalSapling))).setValue((Property)TFCBlockStateProperties.STAGE_3, (Comparable)Integer.valueOf(onBranch ? 1 : 0)));
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TickCountingBranchBlockEntity) {
            TickCountingBranchBlockEntity branch = (TickCountingBranchBlockEntity)blockEntity;
            TickCountingBranchBlockEntity.reset(level, pos);
            TickCountingBranchBlockEntity.addTicks(level, pos, ticksToAdd);
            branch.setStemPos(stemPos);
        }
        level.scheduleTick(pos, this.block.get(), 20, TickPriority.NORMAL);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos downPos = pos.below();
        BlockState downState = level.getBlockState(downPos);
        if (Helpers.isBlock(downState, TFCTags.Blocks.FRUIT_TREE_BRANCH)) {
            if ((Integer)downState.getValue((Property)FruitTreeBranchBlock.STAGE) > 1) {
                return false;
            }
            for (Direction d : Direction.Plane.HORIZONTAL) {
                if (!((Boolean)downState.getValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(d))).booleanValue()) continue;
                return true;
            }
            return false;
        }
        return super.canSurvive(state, level, pos) || Helpers.isBlock(downState, TFCTags.Blocks.BUSH_PLANTABLE_ON);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockPos downPos = pos.below();
        BlockState downState = level.getBlockState(downPos);
        if (Helpers.isBlock(downState, TFCTags.Blocks.FRUIT_TREE_BRANCH)) {
            TickCountingBranchBlockEntity.setStemPos(level, pos, this.findBaseOfTree(level, downPos, downState));
        }
        TickCountingBranchBlockEntity.reset(level, pos);
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    protected BlockPos findBaseOfTree(Level level, BlockPos startPos, BlockState startState) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            if (!((Boolean)startState.getValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(dir))).booleanValue()) continue;
            BlockPos.MutableBlockPos mutablePos = startPos.mutable();
            mutablePos.move(dir, 1);
            while (Helpers.isBlock(level.getBlockState((BlockPos)mutablePos), TFCTags.Blocks.FRUIT_TREE_BRANCH)) {
                mutablePos.move(0, -1, 0);
            }
            return mutablePos.above();
        }
        return startPos;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{SAPLINGS}));
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    protected MapCodec<? extends BushBlock> codec() {
        return this.fakeBlockCodec();
    }

    public final long getTicksToGrow() {
        return (long)((double)this.ticksToGrow.get().intValue() * TFCConfig.SERVER.saplingGrowthModifier.get());
    }
}

