/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.BerryBushBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.plant.fruit.IBushBlock;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.blocks.plant.fruit.SpreadingCaneBlock;
import net.dries007.tfc.common.blocks.plant.fruit.StationaryBerryBushBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SpreadingBushBlock
extends StationaryBerryBushBlock
implements IForgeBlockExtension,
IBushBlock,
HoeOverlayBlock {
    protected final Supplier<? extends Block> companion;
    protected final int maxHeight;

    public SpreadingBushBlock(ExtendedProperties properties, Supplier<? extends Item> productItem, Lifecycle[] stages, Supplier<? extends Block> companion, int maxHeight, Supplier<ClimateRange> climateRange) {
        super(properties, productItem, stages, climateRange);
        this.companion = companion;
        this.maxHeight = maxHeight;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public Block getCane() {
        return this.companion.get();
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Integer)state.getValue((Property)STAGE) == 2 ? Shapes.block() : PLANT_SHAPE;
    }

    @Override
    protected BlockState growAndPropagate(Level level, BlockPos pos, RandomSource random, BlockState state) {
        if (!((Lifecycle)((Object)state.getValue((Property)LIFECYCLE))).active()) {
            return state;
        }
        int originalStage = (Integer)state.getValue((Property)STAGE);
        if (originalStage == 0) {
            return (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(1));
        }
        if (originalStage == 1) {
            Direction offset;
            BlockPos offsetPos;
            BlockPos abovePos = pos.above();
            if (level.isEmptyBlock(abovePos) && SpreadingBushBlock.distanceToGround(level, pos, this.maxHeight) < this.maxHeight) {
                level.setBlockAndUpdate(abovePos, (BlockState)((BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(1))).setValue((Property)LIFECYCLE, (Comparable)((Object)((Lifecycle)((Object)state.getValue((Property)LIFECYCLE))))));
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof BerryBushBlockEntity) {
                    BerryBushBlockEntity sourceBush = (BerryBushBlockEntity)blockEntity;
                    blockEntity = level.getBlockEntity(abovePos);
                    if (blockEntity instanceof BerryBushBlockEntity) {
                        BerryBushBlockEntity newBush = (BerryBushBlockEntity)blockEntity;
                        newBush.setStemPos(sourceBush.getStemPos());
                    }
                }
                return state;
            }
            if (random.nextBoolean() && level.isEmptyBlock(offsetPos = pos.relative(offset = Direction.Plane.HORIZONTAL.getRandomDirection(random)))) {
                level.setBlockAndUpdate(offsetPos, (BlockState)((BlockState)this.companion.get().defaultBlockState().setValue((Property)SpreadingCaneBlock.FACING, (Comparable)offset)).setValue((Property)LIFECYCLE, (Comparable)((Object)((Lifecycle)((Object)state.getValue((Property)LIFECYCLE))))));
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof BerryBushBlockEntity) {
                    BerryBushBlockEntity sourceBush = (BerryBushBlockEntity)blockEntity;
                    blockEntity = level.getBlockEntity(offsetPos);
                    if (blockEntity instanceof BerryBushBlockEntity) {
                        BerryBushBlockEntity newBush = (BerryBushBlockEntity)blockEntity;
                        newBush.setStemPos(sourceBush.getStemPos());
                    }
                }
            }
            return (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(2));
        }
        return state;
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowPos = pos.below();
        BlockState belowState = level.getBlockState(belowPos);
        return this.mayPlaceOn(belowState, (BlockGetter)level, belowPos) || belowState.getBlock() == this && (Integer)belowState.getValue((Property)STAGE) != 0;
    }
}

