/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.plant.fruit.IBushBlock;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.blocks.plant.fruit.SpreadingBushBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SpreadingCaneBlock
extends SpreadingBushBlock
implements IBushBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape CANE_EAST = Block.box((double)0.0, (double)3.0, (double)0.0, (double)8.0, (double)12.0, (double)16.0);
    private static final VoxelShape CANE_WEST = Block.box((double)8.0, (double)3.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape CANE_SOUTH = Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)12.0, (double)8.0);
    private static final VoxelShape CANE_NORTH = Block.box((double)0.0, (double)3.0, (double)8.0, (double)16.0, (double)12.0, (double)16.0);

    public SpreadingCaneBlock(ExtendedProperties properties, Supplier<? extends Item> productItem, Lifecycle[] stages, Supplier<? extends Block> companion, int maxHeight, Supplier<ClimateRange> climateRange) {
        super(properties, productItem, stages, companion, maxHeight, climateRange);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> CANE_NORTH;
            case Direction.WEST -> CANE_WEST;
            case Direction.SOUTH -> CANE_SOUTH;
            default -> CANE_EAST;
        };
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{FACING}));
    }

    @Override
    protected BlockState getDeadState(BlockState state) {
        return (BlockState)((BlockState)((Block)TFCBlocks.DEAD_CANE.get()).defaultBlockState().setValue((Property)STAGE, (Comparable)((Integer)state.getValue((Property)STAGE)))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)));
    }

    @Override
    protected BlockState growAndPropagate(Level level, BlockPos pos, RandomSource random, BlockState state) {
        if (!((Lifecycle)((Object)state.getValue((Property)LIFECYCLE))).active()) {
            return state;
        }
        int prevStage = (Integer)state.getValue((Property)STAGE);
        if (prevStage < 2) {
            return (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(prevStage + 1));
        }
        BlockState placeState = (BlockState)((BlockState)((Block)this.companion.get()).defaultBlockState().setValue((Property)STAGE, (Comparable)Integer.valueOf(1))).setValue((Property)LIFECYCLE, (Comparable)((Object)((Lifecycle)((Object)state.getValue((Property)LIFECYCLE)))));
        if (placeState.canSurvive((LevelReader)level, pos)) {
            level.setBlockAndUpdate(pos, placeState);
        }
        return state;
    }

    @Override
    protected boolean mayDie(Level level, BlockPos pos, BlockState state, int monthsSpentDying) {
        BlockState parent = level.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()));
        if (Helpers.isBlock(parent, TFCTags.Blocks.LIVING_SPREADING_BUSHES)) {
            return false;
        }
        return super.mayDie(level, pos, state, monthsSpentDying);
    }

    @Override
    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    @Override
    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return Helpers.isBlock(level.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite())), TFCTags.Blocks.SPREADING_BUSHES);
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)this.companion.get());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

