/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.BerryBushBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.plant.fruit.IBushBlock;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.blocks.plant.fruit.SeasonalPlantBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StationaryBerryBushBlock
extends SeasonalPlantBlock
implements HoeOverlayBlock,
IBushBlock {
    private static final VoxelShape HALF_PLANT = StationaryBerryBushBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    private static final int MONTHS_SPENT_DORMANT_TO_DIE = 4;

    public StationaryBerryBushBlock(ExtendedProperties properties, Supplier<? extends Item> productItem, Lifecycle[] lifecycle, Supplier<ClimateRange> climateRange) {
        super(properties, climateRange, productItem, lifecycle);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)LIFECYCLE, (Comparable)((Object)(this.getLifecycleForCurrentMonth(context.getLevel(), context.getClickedPos()).active() ? Lifecycle.HEALTHY : Lifecycle.DORMANT)));
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return HALF_PLANT;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        IBushBlock.randomTick(this, state, level, pos, random);
    }

    @Override
    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, Consumer<Component> text, boolean isDebug) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BerryBushBlockEntity) {
            BerryBushBlockEntity bush = (BerryBushBlockEntity)blockEntity;
            ClimateRange range = (ClimateRange)this.climateRange.get();
            BlockPos sourcePos = bush.getStemPos().below();
            int hydration = StationaryBerryBushBlock.getFruitBushHydration(level, pos);
            text.accept(FarmlandBlock.getHydrationTooltip(range, false, hydration));
            text.accept(FarmlandBlock.getAverageTemperatureTooltip(level, sourcePos, range, false));
        }
    }

    @Override
    public void onUpdate(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BerryBushBlockEntity) {
            Lifecycle expectedLifecycle;
            BerryBushBlockEntity bush = (BerryBushBlockEntity)blockEntity;
            Lifecycle currentLifecycle = (Lifecycle)((Object)state.getValue((Property)LIFECYCLE));
            if (!StationaryBerryBushBlock.checkAndSetDormant(level, pos, state, currentLifecycle, expectedLifecycle = this.getLifecycleForCurrentMonth(level, pos))) {
                long deltaTicks = Math.min(bush.getTicksSinceBushUpdate(), Calendars.SERVER.getCalendarTicksInYear());
                long currentCalendarTick = Calendars.SERVER.getCalendarTicks();
                long nextCalendarTick = currentCalendarTick - deltaTicks;
                BlockPos stemPos = bush.getStemPos();
                float temperature = Climate.getAverageTemperature(level, pos);
                int hydration = StationaryBerryBushBlock.getFruitBushHydrationFromRootPos(level, stemPos.below());
                ClimateRange range = (ClimateRange)this.climateRange.get();
                int monthsSpentDying = 0;
                do {
                    nextCalendarTick = Math.min(nextCalendarTick + Calendars.SERVER.getCalendarTicksInMonth(), currentCalendarTick);
                    Lifecycle lifecycleAtNextTick = this.getLifecycleForMonth(ICalendar.getMonthOfYear(nextCalendarTick, Calendars.SERVER.getCalendarDaysInMonth()));
                    currentLifecycle = range.checkBoth(hydration, temperature, false) ? currentLifecycle.advanceTowards(lifecycleAtNextTick) : Lifecycle.DORMANT;
                    if (lifecycleAtNextTick != Lifecycle.DORMANT && currentLifecycle == Lifecycle.DORMANT) {
                        ++monthsSpentDying;
                        continue;
                    }
                    monthsSpentDying = 0;
                } while (nextCalendarTick < currentCalendarTick);
                BlockState newState = this.mayDie(level, pos, state, monthsSpentDying) ? this.getDeadState(state) : this.growAndPropagate(level, pos, level.getRandom(), (BlockState)state.setValue((Property)LIFECYCLE, (Comparable)((Object)currentLifecycle)));
                if (state != newState) {
                    level.setBlock(pos, newState, 3);
                }
            }
        }
    }

    protected boolean mayDie(Level level, BlockPos pos, BlockState state, int monthsSpentDying) {
        return monthsSpentDying >= 4;
    }

    protected BlockState getNewState(Level level, BlockPos pos) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)STAGE, (Comparable)Integer.valueOf(0))).setValue((Property)LIFECYCLE, (Comparable)((Object)Lifecycle.HEALTHY));
    }

    protected boolean canPlaceNewBushAt(Level level, BlockPos pos, BlockState placementState) {
        return level.isEmptyBlock(pos) && placementState.canSurvive((LevelReader)level, pos);
    }

    protected BlockState getDeadState(BlockState state) {
        return (BlockState)((Block)TFCBlocks.DEAD_BERRY_BUSH.get()).defaultBlockState().setValue((Property)STAGE, (Comparable)((Integer)state.getValue((Property)STAGE)));
    }

    protected BlockState growAndPropagate(Level level, BlockPos pos, RandomSource random, BlockState state) {
        if (((Lifecycle)((Object)state.getValue((Property)LIFECYCLE))).active()) {
            return state;
        }
        BlockState newState = (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(Math.min(2, (Integer)state.getValue((Property)STAGE) + 1)));
        if ((Integer)newState.getValue((Property)STAGE) != 2) {
            return newState;
        }
        int count = 0;
        for (BlockPos target : BlockPos.betweenClosed((BlockPos)pos.offset(-2, -1, -2), (BlockPos)pos.offset(2, 1, 2))) {
            if (level.getBlockState(target).getBlock() != this || ++count <= 3) continue;
            return newState;
        }
        BlockPos.MutableBlockPos cursor = pos.mutable();
        for (int tries = 0; tries < 6; ++tries) {
            cursor.setWithOffset((Vec3i)pos, Helpers.triangle(random, 3), Helpers.triangle(random, 2), Helpers.triangle(random, 3));
            BlockState placementState = this.getNewState(level, (BlockPos)cursor);
            if (!this.canPlaceNewBushAt(level, pos, placementState)) continue;
            level.setBlockAndUpdate((BlockPos)cursor, placementState);
            return newState;
        }
        return newState;
    }
}

