/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.blocks.plant.fruit.StationaryBerryBushBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class WaterloggedBerryBushBlock
extends StationaryBerryBushBlock
implements IFluidLoggable {
    public static final FluidProperty FLUID = TFCBlockStateProperties.FRESH_WATER;

    public WaterloggedBerryBushBlock(ExtendedProperties properties, Supplier<? extends Item> productItem, Lifecycle[] lifecycle, Supplier<ClimateRange> climateRange) {
        super(properties, productItem, lifecycle, climateRange);
    }

    @Override
    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, Consumer<Component> text, boolean isDebug) {
        BlockPos sourcePos = pos.below();
        ClimateRange range = (ClimateRange)this.climateRange.get();
        if (((FluidProperty.FluidKey)state.getValue((Property)this.getFluidProperty())).getFluid() == Fluids.EMPTY) {
            text.accept((Component)Component.translatable((String)"tfc.tooltip.berry_bush.not_underwater"));
        }
        text.accept(FarmlandBlock.getAverageTemperatureTooltip(level, sourcePos, range, false));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{this.getFluidProperty()}));
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        return state.canSurvive((LevelReader)level, currentPos) ? super.updateShape(state, facing, facingState, level, currentPos, facingPos) : state.getFluidState().createLegacyBlock();
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = this.defaultBlockState();
        state = FluidHelpers.fillWithFluid(state, context.getLevel().getFluidState(context.getClickedPos()).getType());
        return state;
    }

    @Override
    public FluidState getFluidState(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }

    @Override
    public FluidProperty getFluidProperty() {
        return FLUID;
    }

    @Override
    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return super.mayPlaceOn(state, level, pos) || Helpers.isBlock(level.getBlockState(pos.below()), TFCTags.Blocks.SEA_BUSH_PLANTABLE_ON);
    }

    @Override
    protected BlockState getNewState(Level level, BlockPos pos) {
        return (BlockState)super.getNewState(level, pos).setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyForOrEmpty(level.getFluidState(pos).getType()));
    }

    @Override
    protected boolean canPlaceNewBushAt(Level level, BlockPos pos, BlockState placementState) {
        return placementState.canSurvive((LevelReader)level, pos) && FluidHelpers.isAirOrEmptyFluid(level.getBlockState(pos)) && this.getFluidProperty().canContain(level.getFluidState(pos).getType());
    }
}

