/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.rock;

import com.mojang.serialization.MapCodec;
import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AqueductBlock
extends HorizontalDirectionalBlock
implements IFluidLoggable {
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final FluidProperty FLUID = TFCBlockStateProperties.ALL_WATER_AND_LAVA;
    private static final VoxelShape[] SHAPES = new VoxelShape[16];
    private static final int SHORT_TICK_DELAY = 5;
    private static final int LONG_TICK_DELAY = 20;

    private static boolean isValidSource(BlockState state) {
        return !state.isAir() && (state.getFluidState().isSource() || state.getFluidState().hasProperty((Property)FlowingFluid.LEVEL) && (Integer)state.getFluidState().getValue((Property)FlowingFluid.LEVEL) == 8);
    }

    private static BlockState updateOpenSides(LevelAccessor level, BlockPos pos, BlockState state) {
        int openSides = 0;
        Direction openDirection = null;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos adjacentPos = pos.relative(direction);
            BlockState adjacentState = level.getBlockState(adjacentPos);
            boolean adjacentAqueduct = adjacentState.getBlock() instanceof AqueductBlock;
            if (adjacentAqueduct) {
                ++openSides;
                openDirection = direction;
            }
            state = (BlockState)state.setValue((Property)DirectionPropertyBlock.getProperty(direction), (Comparable)Boolean.valueOf(adjacentAqueduct));
        }
        if (openSides == 1) {
            state = (BlockState)state.setValue((Property)DirectionPropertyBlock.getProperty(openDirection.getOpposite()), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    private static void tickAllAdjacentAqueducts(LevelAccessor level, BlockPos pos, int tickDelay, @Nullable Direction excludedDirection) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos adjacentPos;
            BlockState adjacentState;
            if (direction == excludedDirection || !((adjacentState = level.getBlockState(adjacentPos = pos.relative(direction))).getBlock() instanceof AqueductBlock)) continue;
            level.scheduleTick(adjacentPos, adjacentState.getBlock(), tickDelay);
        }
    }

    public AqueductBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(Fluids.EMPTY)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return AqueductBlock.updateOpenSides((LevelAccessor)context.getLevel(), context.getClickedPos(), this.defaultBlockState());
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        level.scheduleTick(pos, (Block)this, 20);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.getBlock() != this && ((FluidProperty.FluidKey)state.getValue((Property)this.getFluidProperty())).getFluid() != Fluids.EMPTY && newState.getFluidState().getType().isSame(((FluidProperty.FluidKey)state.getValue((Property)this.getFluidProperty())).getFluid())) {
            BlockState blockState;
            Fluid fluid = newState.getFluidState().getType();
            if (fluid instanceof FlowingFluid) {
                FlowingFluid fluid2 = (FlowingFluid)fluid;
                blockState = fluid2.getFlowing(1, false).createLegacyBlock();
            } else {
                blockState = Blocks.AIR.defaultBlockState();
            }
            BlockState newFluidState = blockState;
            level.setBlock(pos, newFluidState, 2);
        }
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[((Boolean)state.getValue((Property)NORTH) != false ? 1 << Direction.NORTH.get2DDataValue() : 0) | ((Boolean)state.getValue((Property)EAST) != false ? 1 << Direction.EAST.get2DDataValue() : 0) | ((Boolean)state.getValue((Property)SOUTH) != false ? 1 << Direction.SOUTH.get2DDataValue() : 0) | ((Boolean)state.getValue((Property)WEST) != false ? 1 << Direction.WEST.get2DDataValue() : 0)];
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState adjacentState, LevelAccessor level, BlockPos pos, BlockPos adjacentPos) {
        FluidHelpers.tickFluid(level, pos, state);
        BlockState newState = AqueductBlock.updateOpenSides(level, pos, state);
        if (state != newState || (((FluidProperty.FluidKey)state.getValue((Property)this.getFluidProperty())).getFluid() == Fluids.EMPTY ? direction.getAxis().getPlane() == Direction.Plane.HORIZONTAL && (Boolean)state.getValue((Property)DirectionPropertyBlock.getProperty(direction)) != false : direction == state.getValue((Property)FACING))) {
            level.scheduleTick(pos, (Block)this, 20);
        }
        return newState;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, FACING, this.getFluidProperty()});
    }

    @Override
    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        boolean result = IFluidLoggable.super.placeLiquid(level, pos, state, fluidStateIn);
        if (result) {
            level.scheduleTick(pos, (Block)this, 5);
        }
        return result;
    }

    @Override
    public ItemStack pickupBlock(@Nullable Player player, LevelAccessor level, BlockPos pos, BlockState state) {
        Fluid containedFluid = ((FluidProperty.FluidKey)state.getValue((Property)this.getFluidProperty())).getFluid();
        if (containedFluid == Fluids.LAVA) {
            return ItemStack.EMPTY;
        }
        if (containedFluid != Fluids.EMPTY) {
            level.scheduleTick(pos, (Block)this, 20);
        }
        return IFluidLoggable.super.pickupBlock(player, level, pos, state);
    }

    @Override
    public FluidState getFluidState(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }

    @Override
    public FluidProperty getFluidProperty() {
        return FLUID;
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        Direction sourceDirection = (Direction)state.getValue((Property)FACING);
        FluidProperty.FluidKey sourceFluid = (FluidProperty.FluidKey)state.getValue((Property)this.getFluidProperty());
        if (sourceFluid.getFluid() != Fluids.EMPTY) {
            boolean valid = false;
            if (((Boolean)state.getValue((Property)DirectionPropertyBlock.getProperty(sourceDirection))).booleanValue()) {
                BlockState sourceState = level.getBlockState(pos.relative(sourceDirection));
                if (sourceState.getBlock() instanceof AqueductBlock) {
                    valid = sourceState.getValue((Property)this.getFluidProperty()) == sourceFluid && sourceState.getValue((Property)FACING) != sourceDirection.getOpposite();
                } else if (AqueductBlock.isValidSource(sourceState) && sourceState.getFluidState().getType().isSame(sourceFluid.getFluid())) {
                    valid = true;
                }
            }
            if (!valid) {
                state = (BlockState)state.setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(Fluids.EMPTY));
                AqueductBlock.tickAllAdjacentAqueducts((LevelAccessor)level, pos, 5, sourceDirection);
                level.setBlockAndUpdate(pos, state);
            }
        } else {
            boolean filled = false;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Fluid adjacentFluid;
                if (!((Boolean)state.getValue((Property)DirectionPropertyBlock.getProperty(direction))).booleanValue()) continue;
                BlockPos adjacentPos = pos.relative(direction);
                BlockState adjacentState = level.getBlockState(adjacentPos);
                Fluid fluid = adjacentState.getFluidState().getType();
                if (fluid instanceof FlowingFluid) {
                    FlowingFluid flow = (FlowingFluid)fluid;
                    v0 = flow.getSource();
                } else {
                    v0 = adjacentFluid = adjacentState.getFluidState().getType();
                }
                if (adjacentState.getBlock() instanceof AqueductBlock) {
                    if (!((Boolean)adjacentState.getValue((Property)DirectionPropertyBlock.getProperty(direction.getOpposite()))).booleanValue() || adjacentState.getValue((Property)FACING) == direction.getOpposite() || ((FluidProperty.FluidKey)adjacentState.getValue((Property)this.getFluidProperty())).getFluid() == Fluids.EMPTY) continue;
                    state = (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)direction)).setValue((Property)this.getFluidProperty(), (Comparable)((FluidProperty.FluidKey)adjacentState.getValue((Property)this.getFluidProperty())));
                    filled = true;
                    break;
                }
                if (!AqueductBlock.isValidSource(adjacentState) || !this.getFluidProperty().canContain(adjacentFluid)) continue;
                state = (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)direction)).setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(adjacentFluid));
                filled = true;
                break;
            }
            if (filled) {
                level.setBlockAndUpdate(pos, state);
                level.scheduleTick(pos, state.getFluidState().getType(), state.getFluidState().getType().getTickDelay((LevelReader)level));
                AqueductBlock.tickAllAdjacentAqueducts((LevelAccessor)level, pos, 20, (Direction)state.getValue((Property)FACING));
            }
        }
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return state.getFluidState().isRandomlyTicking();
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        state.getFluidState().randomTick((Level)level, pos, random);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return DirectionPropertyBlock.rotate(super.rotate(state, rot), rot);
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)DirectionPropertyBlock.mirror(state, mirror).setValue((Property)FACING, (Comparable)mirror.mirror((Direction)state.getValue((Property)FACING)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return IForgeBlockExtension.getFakeBlockCodec();
    }

    static {
        VoxelShape north = AqueductBlock.box((double)4.0, (double)10.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0);
        VoxelShape east = AqueductBlock.box((double)12.0, (double)10.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
        VoxelShape south = AqueductBlock.box((double)4.0, (double)10.0, (double)12.0, (double)12.0, (double)16.0, (double)16.0);
        VoxelShape west = AqueductBlock.box((double)0.0, (double)10.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0);
        VoxelShape[] directions = new VoxelShape[]{south, west, north, east};
        VoxelShape base = Shapes.or((VoxelShape)AqueductBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), (VoxelShape[])new VoxelShape[]{AqueductBlock.box((double)0.0, (double)10.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0), AqueductBlock.box((double)12.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), AqueductBlock.box((double)0.0, (double)10.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0), AqueductBlock.box((double)12.0, (double)10.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0)});
        for (int i = 0; i < SHAPES.length; ++i) {
            VoxelShape shape = base;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if ((i >> direction.get2DDataValue() & 1) != 0) continue;
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)directions[direction.get2DDataValue()]);
            }
            AqueductBlock.SHAPES[i] = shape;
        }
    }
}

