/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.rock;

import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.GroundcoverBlock;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LooseRockBlock
extends GroundcoverBlock
implements IFluidLoggable {
    public static final IntegerProperty COUNT = TFCBlockStateProperties.COUNT_1_3;
    private static final VoxelShape ONE = LooseRockBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0);
    private static final VoxelShape TWO = LooseRockBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    private static final VoxelShape THREE = LooseRockBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0);

    public LooseRockBlock(BlockBehaviour.Properties properties) {
        super(ExtendedProperties.of(properties), Shapes.empty());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)COUNT, (Comparable)Integer.valueOf(1)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{COUNT}));
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.getItem() == this.asItem()) {
            BlockState newState;
            int count;
            if (hand == InteractionHand.MAIN_HAND && state.getBlock() == this && (count = ((Integer)state.getValue((Property)COUNT)).intValue()) < 3 && (newState = (BlockState)state.setValue((Property)COUNT, (Comparable)Integer.valueOf(count + 1))).canSurvive((LevelReader)level, pos)) {
                Helpers.playPlaceSound(player, (LevelAccessor)level, pos, state);
                level.setBlockAndUpdate(pos, newState);
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowPos = pos.below();
        BlockState below = level.getBlockState(belowPos);
        return below.isFaceSturdy((BlockGetter)level, belowPos, Direction.UP, (Integer)state.getValue((Property)COUNT) == 1 ? SupportType.CENTER : SupportType.FULL);
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.getValue((Property)COUNT)) {
            case 1 -> ONE;
            case 2 -> TWO;
            case 3 -> THREE;
            default -> throw new IllegalStateException("Unknown value for property LooseRockBlock#ROCKS: " + String.valueOf(state.getValue((Property)COUNT)));
        };
    }
}

