/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.rock;

import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.dries007.tfc.common.Lore;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.AqueductBlock;
import net.dries007.tfc.common.blocks.rock.LooseRockBlock;
import net.dries007.tfc.common.blocks.rock.MossGrowingBlock;
import net.dries007.tfc.common.blocks.rock.MossGrowingSlabBlock;
import net.dries007.tfc.common.blocks.rock.MossGrowingStairsBlock;
import net.dries007.tfc.common.blocks.rock.MossGrowingWallBlock;
import net.dries007.tfc.common.blocks.rock.MossSpreadingBlock;
import net.dries007.tfc.common.blocks.rock.MossSpreadingSlabBlock;
import net.dries007.tfc.common.blocks.rock.MossSpreadingStairBlock;
import net.dries007.tfc.common.blocks.rock.MossSpreadingWallBlock;
import net.dries007.tfc.common.blocks.rock.RockConvertableToAnvilBlock;
import net.dries007.tfc.common.blocks.rock.RockDisplayCategory;
import net.dries007.tfc.common.blocks.rock.RockSpikeBlock;
import net.dries007.tfc.util.registry.RegistryRock;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.Nullable;

public enum Rock implements RegistryRock
{
    GRANITE(RockDisplayCategory.FELSIC_IGNEOUS_INTRUSIVE, MapColor.RAW_IRON),
    DIORITE(RockDisplayCategory.INTERMEDIATE_IGNEOUS_INTRUSIVE, MapColor.METAL),
    GABBRO(RockDisplayCategory.MAFIC_IGNEOUS_INTRUSIVE, MapColor.COLOR_GRAY),
    SHALE(RockDisplayCategory.SEDIMENTARY, MapColor.COLOR_GRAY),
    CLAYSTONE(RockDisplayCategory.SEDIMENTARY, MapColor.TERRACOTTA_YELLOW),
    LIMESTONE(RockDisplayCategory.SEDIMENTARY, MapColor.TERRACOTTA_WHITE),
    CONGLOMERATE(RockDisplayCategory.SEDIMENTARY, MapColor.TERRACOTTA_LIGHT_GRAY),
    DOLOMITE(RockDisplayCategory.SEDIMENTARY, MapColor.COLOR_GRAY),
    CHERT(RockDisplayCategory.SEDIMENTARY, MapColor.TERRACOTTA_ORANGE),
    CHALK(RockDisplayCategory.SEDIMENTARY, MapColor.QUARTZ),
    TUFF(RockDisplayCategory.SEDIMENTARY, MapColor.TERRACOTTA_GRAY),
    RHYOLITE(RockDisplayCategory.FELSIC_IGNEOUS_EXTRUSIVE, MapColor.TERRACOTTA_LIGHT_GRAY),
    BASALT(RockDisplayCategory.MAFIC_IGNEOUS_EXTRUSIVE, MapColor.COLOR_BLACK),
    ANDESITE(RockDisplayCategory.INTERMEDIATE_IGNEOUS_EXTRUSIVE, MapColor.TERRACOTTA_CYAN),
    DACITE(RockDisplayCategory.INTERMEDIATE_IGNEOUS_EXTRUSIVE, MapColor.STONE),
    QUARTZITE(RockDisplayCategory.METAMORPHIC, MapColor.TERRACOTTA_WHITE),
    SLATE(RockDisplayCategory.METAMORPHIC, MapColor.WOOD),
    PHYLLITE(RockDisplayCategory.METAMORPHIC, MapColor.TERRACOTTA_LIGHT_BLUE),
    SCHIST(RockDisplayCategory.METAMORPHIC, MapColor.TERRACOTTA_LIGHT_GREEN),
    GNEISS(RockDisplayCategory.METAMORPHIC, MapColor.TERRACOTTA_LIGHT_GRAY),
    MARBLE(RockDisplayCategory.METAMORPHIC, MapColor.WOOL);

    public static final Rock[] VALUES;
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final RockDisplayCategory category;
    private final MapColor color;

    private Rock(RockDisplayCategory category, MapColor color) {
        this.category = category;
        this.color = color;
    }

    public Item.Properties createItemProperties() {
        return new Item.Properties().component(Lore.TYPE, (Object)Lore.ROCK_DISPLAY_CATEGORIES.get((Object)this.category));
    }

    @Override
    public RockDisplayCategory displayCategory() {
        return this.category;
    }

    @Override
    public MapColor color() {
        return this.color;
    }

    @Override
    public Supplier<? extends Block> getBlock(BlockType type) {
        return TFCBlocks.ROCK_BLOCKS.get(this).get((Object)type);
    }

    @Override
    public Supplier<? extends Block> getAnvil() {
        return TFCBlocks.ROCK_ANVILS.get(this);
    }

    @Override
    public Supplier<? extends SlabBlock> getSlab(BlockType type) {
        return TFCBlocks.ROCK_DECORATIONS.get(this).get((Object)type).slab();
    }

    @Override
    public Supplier<? extends StairBlock> getStair(BlockType type) {
        return TFCBlocks.ROCK_DECORATIONS.get(this).get((Object)type).stair();
    }

    @Override
    public Supplier<? extends WallBlock> getWall(BlockType type) {
        return TFCBlocks.ROCK_DECORATIONS.get(this).get((Object)type).wall();
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    static {
        VALUES = Rock.values();
    }

    public static enum BlockType implements StringRepresentable
    {
        RAW((rock, self) -> RockConvertableToAnvilBlock.createForIgneousOnly(BlockType.properties(rock).strength(rock.category().hardness(6.5f), 10.0f).requiresCorrectToolForDrops(), rock, false), true),
        HARDENED((rock, self) -> RockConvertableToAnvilBlock.createForIgneousOnly(BlockType.properties(rock).strength(rock.category().hardness(8.0f), 10.0f).requiresCorrectToolForDrops(), rock, true), false),
        SMOOTH((rock, self) -> new Block(BlockType.properties(rock).strength(rock.category().hardness(6.5f), 10.0f).requiresCorrectToolForDrops()), true),
        COBBLE((rock, self) -> new MossGrowingBlock(BlockType.properties(rock).strength(rock.category().hardness(5.5f), 10.0f).requiresCorrectToolForDrops(), rock.getBlock(Objects.requireNonNull(self.mossy()))), true),
        BRICKS((rock, self) -> new MossGrowingBlock(BlockType.properties(rock).strength(rock.category().hardness(6.5f), 10.0f).requiresCorrectToolForDrops(), rock.getBlock(Objects.requireNonNull(self.mossy()))), true),
        GRAVEL((rock, self) -> new Block(BlockBehaviour.Properties.of().mapColor(rock.color()).sound(SoundType.GRAVEL).instrument(NoteBlockInstrument.SNARE).strength(rock.category().hardness(2.0f))), false),
        SPIKE((rock, self) -> new RockSpikeBlock(BlockType.properties(rock).strength(rock.category().hardness(4.0f), 10.0f).requiresCorrectToolForDrops().lightLevel(TFCBlocks.lavaLoggedBlockEmission())), false),
        CRACKED_BRICKS((rock, self) -> new Block(BlockType.properties(rock).strength(rock.category().hardness(6.5f), 10.0f).requiresCorrectToolForDrops()), true),
        MOSSY_BRICKS((rock, self) -> new MossSpreadingBlock(BlockType.properties(rock).strength(rock.category().hardness(6.5f), 10.0f).requiresCorrectToolForDrops()), true),
        MOSSY_COBBLE((rock, self) -> new MossSpreadingBlock(BlockType.properties(rock).strength(rock.category().hardness(6.5f), 10.0f).requiresCorrectToolForDrops()), true),
        CHISELED((rock, self) -> new Block(BlockType.properties(rock).strength(rock.category().hardness(8.0f), 10.0f).requiresCorrectToolForDrops()), false),
        LOOSE((rock, self) -> new LooseRockBlock(BlockType.properties(rock).strength(0.05f, 0.0f).noCollission()), false),
        MOSSY_LOOSE((rock, self) -> new LooseRockBlock(BlockType.properties(rock).strength(0.05f, 0.0f).noCollission()), false),
        PRESSURE_PLATE((rock, self) -> new PressurePlateBlock(BlockSetType.STONE, BlockType.properties(rock).requiresCorrectToolForDrops().noCollission().strength(0.5f)), false),
        BUTTON((rock, self) -> new ButtonBlock(BlockSetType.STONE, 20, BlockType.properties(rock).noCollission().strength(0.5f)), false),
        AQUEDUCT((rock, self) -> new AqueductBlock(BlockType.properties(rock).strength(rock.category().hardness(6.5f), 10.0f).requiresCorrectToolForDrops().lightLevel(TFCBlocks.lavaLoggedBlockEmission())), false);

        public static final BlockType[] VALUES;
        private final boolean variants;
        private final BiFunction<RegistryRock, BlockType, Block> blockFactory;
        private final String serializedName;

        public static BlockType valueOf(int i) {
            return i >= 0 && i < VALUES.length ? VALUES[i] : RAW;
        }

        private static BlockBehaviour.Properties properties(RegistryRock rock) {
            return BlockBehaviour.Properties.of().mapColor(rock.color()).sound(SoundType.STONE).instrument(NoteBlockInstrument.BASEDRUM);
        }

        private BlockType(BiFunction<RegistryRock, BlockType, Block> blockFactory, boolean variants) {
            this.blockFactory = blockFactory;
            this.variants = variants;
            this.serializedName = this.name().toLowerCase(Locale.ROOT);
        }

        public boolean hasVariants() {
            return this.variants;
        }

        public Block create(RegistryRock rock) {
            return this.blockFactory.apply(rock, this);
        }

        public SlabBlock createSlab(RegistryRock rock) {
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.of().mapColor(MapColor.STONE).sound(SoundType.STONE).strength(1.5f, 10.0f).requiresCorrectToolForDrops();
            BlockType mossy = this.mossy();
            if (mossy == this) {
                return new MossSpreadingSlabBlock(properties);
            }
            if (mossy != null) {
                return new MossGrowingSlabBlock(properties, rock.getSlab(mossy));
            }
            return new SlabBlock(properties);
        }

        public StairBlock createStairs(RegistryRock rock) {
            Supplier<BlockState> state = () -> rock.getBlock(this).get().defaultBlockState();
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.of().mapColor(MapColor.STONE).sound(SoundType.STONE).strength(1.5f, 10.0f).requiresCorrectToolForDrops();
            BlockType mossy = this.mossy();
            if (mossy == this) {
                return new MossSpreadingStairBlock(state, properties);
            }
            if (mossy != null) {
                return new MossGrowingStairsBlock(state, properties, rock.getStair(mossy));
            }
            return new StairBlock(state.get(), properties);
        }

        public WallBlock createWall(RegistryRock rock) {
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.of().mapColor(MapColor.STONE).sound(SoundType.STONE).strength(1.5f, 10.0f).requiresCorrectToolForDrops();
            BlockType mossy = this.mossy();
            if (mossy == this) {
                return new MossSpreadingWallBlock(properties);
            }
            if (mossy != null) {
                return new MossGrowingWallBlock(properties, rock.getWall(mossy));
            }
            return new WallBlock(properties);
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        @Nullable
        private BlockType mossy() {
            return switch (this.ordinal()) {
                case 3, 9 -> MOSSY_COBBLE;
                case 4, 8 -> MOSSY_BRICKS;
                default -> null;
            };
        }

        static {
            VALUES = BlockType.values();
        }
    }
}

