/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.rock;

import java.util.Locale;
import java.util.function.Function;
import net.dries007.tfc.common.Lore;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.TFCTiers;
import net.dries007.tfc.common.items.HammerItem;
import net.dries007.tfc.common.items.JavelinItem;
import net.dries007.tfc.common.items.TFCHoeItem;
import net.dries007.tfc.common.items.ToolItem;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;

public enum RockCategory implements StringRepresentable
{
    IGNEOUS_EXTRUSIVE(TFCTiers.IGNEOUS_EXTRUSIVE, 0.0f),
    IGNEOUS_INTRUSIVE(TFCTiers.IGNEOUS_INTRUSIVE, 0.2f),
    METAMORPHIC(TFCTiers.METAMORPHIC, -0.2f),
    SEDIMENTARY(TFCTiers.SEDIMENTARY, -0.4f);

    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final Tier itemTier;
    private final float hardnessModifier;

    private RockCategory(Tier itemTier, float hardnessModifier) {
        this.itemTier = itemTier;
        this.hardnessModifier = hardnessModifier;
    }

    public Tier tier() {
        return this.itemTier;
    }

    public float hardness(float base) {
        return base + this.hardnessModifier;
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    public static enum ItemType {
        AXE(rock -> new AxeItem(rock.tier(), ItemType.tool(rock, 1.5f, -3.2f))),
        AXE_HEAD,
        HAMMER(rock -> new HammerItem(rock.tier(), ItemType.tool(rock, 1.0f, -3.0f))),
        HAMMER_HEAD,
        HOE(rock -> new TFCHoeItem(rock.tier(), ItemType.tool(rock, 0.5f, -3.0f))),
        HOE_HEAD,
        JAVELIN(rock -> new JavelinItem(rock.tier(), ItemType.tool(rock, 0.7f, -2.2f))),
        JAVELIN_HEAD,
        KNIFE(rock -> new ToolItem(rock.tier(), TFCTags.Blocks.MINEABLE_WITH_KNIFE, ItemType.tool(rock, 0.6f, -2.0f))),
        KNIFE_HEAD,
        SHOVEL(rock -> new ShovelItem(rock.tier(), ItemType.tool(rock, 0.875f, -3.0f))),
        SHOVEL_HEAD;

        private final Function<RockCategory, Item> itemFactory;

        public static Item.Properties tool(RockCategory rock, float attackDamageFactor, float attackSpeed) {
            return new Item.Properties().attributes(ToolItem.productAttributes(rock.tier(), attackDamageFactor, attackSpeed));
        }

        private ItemType() {
            this(rock -> new Item(new Item.Properties().component(Lore.TYPE, (Object)Lore.ROCK_CATEGORIES.get(rock))));
        }

        private ItemType(Function<RockCategory, Item> itemFactory) {
            this.itemFactory = itemFactory;
        }

        public Item create(RockCategory category) {
            return this.itemFactory.apply(category);
        }
    }
}

