/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.rock;

import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.rock.RawRockBlock;
import net.dries007.tfc.common.blocks.rock.RockCategory;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.dries007.tfc.util.registry.RegistryRock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class RockConvertableToAnvilBlock
extends RotatedPillarBlock {
    private final Supplier<? extends Block> anvil;

    public static Block createForIgneousOnly(BlockBehaviour.Properties properties, RegistryRock rock, boolean naturallySupported) {
        return rock.category() == RockCategory.IGNEOUS_EXTRUSIVE || rock.category() == RockCategory.IGNEOUS_INTRUSIVE ? new RockConvertableToAnvilBlock(properties, rock.getAnvil()) : (naturallySupported ? new RotatedPillarBlock(properties) : new RawRockBlock(properties));
    }

    public RockConvertableToAnvilBlock(BlockBehaviour.Properties properties, Supplier<? extends Block> anvil) {
        super(properties);
        this.anvil = anvil;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (Helpers.isItem(stack, TFCTags.Items.TOOLS_HAMMER) && !Helpers.isItem(player.getItemInHand(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND), TFCTags.Items.TOOLS_CHISEL) && hitResult.getDirection() == Direction.UP && level.getBlockState(pos.above()).isAir()) {
            BlockState block = this.anvil.get().defaultBlockState();
            level.setBlockAndUpdate(pos, block);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                TFCAdvancements.ROCK_ANVIL.trigger(serverPlayer, block);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

