/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.rotation;

import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.rotation.ClutchBlockEntity;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.rotation.AxleBlock;
import net.dries007.tfc.common.blocks.rotation.ConnectedAxleBlock;
import net.dries007.tfc.common.blocks.wood.ExtendedRotatedPillarBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class ClutchBlock
extends ExtendedRotatedPillarBlock
implements EntityBlockExtension,
ConnectedAxleBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private final Supplier<? extends AxleBlock> axle;

    public ClutchBlock(ExtendedProperties properties, Supplier<? extends AxleBlock> axle) {
        super(properties);
        this.axle = axle;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)AXIS, (Comparable)Direction.Axis.Y));
    }

    @Override
    public AxleBlock getAxle() {
        return this.axle.get();
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean signal = level.hasNeighborSignal(pos);
        if (signal != (Boolean)state.getValue((Property)POWERED)) {
            level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)POWERED));
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof ClutchBlockEntity) {
                ClutchBlockEntity clutch = (ClutchBlockEntity)blockEntity;
                clutch.updateConnections();
            }
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state != null) {
            return (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
        }
        return null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{POWERED}));
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && random.nextFloat() < 0.1f) {
            ParticleUtils.spawnParticlesOnBlockFaces((Level)level, (BlockPos)pos, (ParticleOptions)DustParticleOptions.REDSTONE, (IntProvider)UniformInt.of((int)1, (int)3));
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ClutchBlockEntity) {
            ClutchBlockEntity entity = (ClutchBlockEntity)blockEntity;
            entity.destroyIfInvalid((Level)level, pos);
        }
    }
}

