/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.rotation;

import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.rotation.RotatingBlockEntity;
import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.blocks.rotation.AxleBlock;
import net.dries007.tfc.common.blocks.rotation.ConnectedAxleBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class GearBoxBlock
extends DeviceBlock
implements DirectionPropertyBlock,
ConnectedAxleBlock {
    private final Supplier<? extends AxleBlock> axle;

    public GearBoxBlock(ExtendedProperties properties, Supplier<? extends AxleBlock> axle) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.NOOP);
        this.axle = axle;
        this.registerDefaultState(DirectionPropertyBlock.setAllDirections((BlockState)this.getStateDefinition().any(), false));
    }

    @Override
    public AxleBlock getAxle() {
        return this.axle.get();
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (Helpers.isItem(player.getItemInHand(hand), TFCTags.Items.TOOLS_HAMMER)) {
            Direction direction = player.isShiftKeyDown() ? hitResult.getDirection().getOpposite() : hitResult.getDirection();
            BooleanProperty property = DirectionPropertyBlock.getProperty(direction);
            boolean prev = (Boolean)state.getValue((Property)property);
            if (prev || this.canEnable(state, property)) {
                level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)property));
                level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.GEAR_BOX.get()).ifPresent(box -> box.updateDirection(direction, !prev));
                Helpers.playPlaceSound(player, (LevelAccessor)level, pos, state);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            Helpers.playSound(level, pos, SoundEvents.ITEM_BREAK);
            return ItemInteractionResult.FAIL;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private boolean canEnable(BlockState state, BooleanProperty direction) {
        return (Boolean)(state = (BlockState)state.setValue((Property)direction, (Comparable)Boolean.valueOf(true))).getValue((Property)NORTH) == false && (Boolean)state.getValue((Property)SOUTH) == false || (Boolean)state.getValue((Property)EAST) == false && (Boolean)state.getValue((Property)WEST) == false || (Boolean)state.getValue((Property)UP) == false && (Boolean)state.getValue((Property)DOWN) == false;
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RotatingBlockEntity) {
            RotatingBlockEntity entity = (RotatingBlockEntity)blockEntity;
            entity.destroyIfInvalid((Level)level, pos);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, DOWN, NORTH, SOUTH, EAST, WEST});
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rot) {
        return DirectionPropertyBlock.rotate(state, rot);
    }

    @Override
    public BlockState mirror(BlockState state, Mirror mirror) {
        return DirectionPropertyBlock.mirror(state, mirror);
    }
}

