/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.rotation;

import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.rotation.RotatingBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.WindmillBlockEntity;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.blocks.rotation.AxleBlock;
import net.dries007.tfc.common.blocks.rotation.ConnectedAxleBlock;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class WindmillBlock
extends DeviceBlock
implements EntityBlockExtension,
ConnectedAxleBlock {
    public static final IntegerProperty COUNT = TFCBlockStateProperties.COUNT_1_5;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    private final Supplier<? extends AxleBlock> axle;

    public WindmillBlock(ExtendedProperties properties, Supplier<? extends AxleBlock> axle) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.axle = axle;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)COUNT, (Comparable)Integer.valueOf(1)));
    }

    @Override
    public AxleBlock getAxle() {
        return this.axle.get();
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RotatingBlockEntity) {
            RotatingBlockEntity entity = (RotatingBlockEntity)blockEntity;
            entity.destroyIfInvalid((Level)level, pos);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        int count = (Integer)state.getValue((Property)COUNT);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof WindmillBlockEntity) {
            WindmillBlockEntity windmill = (WindmillBlockEntity)blockEntity;
            Object inv = windmill.getInventory();
            if (count < 5 && !stack.isEmpty()) {
                ItemStack leftover = Helpers.insertAllSlots(inv, player.isCreative() ? stack.copyWithCount(1) : stack.split(1));
                if (!leftover.isEmpty()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)leftover);
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
                int newCount = windmill.updateState();
                if (newCount == 5 && player instanceof ServerPlayer) {
                    ServerPlayer server = (ServerPlayer)player;
                    TFCAdvancements.MAX_WINDMILL.trigger(server);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (count == 5 || stack.isEmpty()) {
                if (!player.getAbilities().instabuild) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)inv.extractItem(count - 1, 1, false));
                } else {
                    inv.extractItem(count - 1, 1, false);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{AXIS, COUNT}));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.getValue(AXIS) == Direction.Axis.X ? AxleBlock.SHAPE_X : AxleBlock.SHAPE_Z;
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)TFCItems.WINDMILL_BLADES.get(DyeColor.WHITE));
    }
}

