/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.soil;

import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.soil.IDirtBlock;
import net.dries007.tfc.common.blocks.soil.IMudBlock;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.registry.RegistrySoilVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.Nullable;

public class DirtBlock
extends Block
implements IDirtBlock,
IMudBlock {
    private final Supplier<? extends Block> grass;
    @Nullable
    private final Supplier<? extends Block> path;
    @Nullable
    private final Supplier<? extends Block> farmland;
    private final Supplier<? extends Block> rooted;
    private final Supplier<? extends Block> mud;

    public static boolean emptyBlockAbove(UseOnContext context) {
        return context.getClickedFace() != Direction.DOWN && FluidHelpers.isAirOrEmptyFluid(context.getLevel().getBlockState(context.getClickedPos().above()));
    }

    public DirtBlock(BlockBehaviour.Properties properties, Supplier<? extends Block> grass, @Nullable Supplier<? extends Block> path, @Nullable Supplier<? extends Block> farmland, Supplier<? extends Block> rooted, Supplier<? extends Block> mud) {
        super(properties);
        this.grass = grass;
        this.path = path;
        this.farmland = farmland;
        this.rooted = rooted;
        this.mud = mud;
    }

    DirtBlock(BlockBehaviour.Properties properties, SoilBlockType grassType, RegistrySoilVariant variant) {
        this(properties, variant.getBlock(grassType), variant.getBlock(SoilBlockType.GRASS_PATH), variant.getBlock(SoilBlockType.FARMLAND), variant.getBlock(SoilBlockType.ROOTED_DIRT), variant.getBlock(SoilBlockType.MUD));
    }

    @Override
    public BlockState getGrass() {
        return this.grass.get().defaultBlockState();
    }

    public BlockState getRooted() {
        return this.rooted.get().defaultBlockState();
    }

    @Override
    public BlockState getMud() {
        return this.mud.get().defaultBlockState();
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility action, boolean simulate) {
        if (context.getItemInHand().canPerformAction(action)) {
            if (action == ItemAbilities.SHOVEL_FLATTEN && this.path != null && TFCConfig.SERVER.enableGrassPathCreation.get().booleanValue()) {
                return this.path.get().defaultBlockState();
            }
            if (action == ItemAbilities.HOE_TILL && this.farmland != null && TFCConfig.SERVER.enableFarmlandCreation.get().booleanValue() && DirtBlock.emptyBlockAbove(context)) {
                return this.farmland.get().defaultBlockState();
            }
        }
        return null;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return this.transformToMud(this.mud.get().defaultBlockState(), level, pos, player, hand);
    }
}

