/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.soil;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.IFarmland;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.crop.CropHelpers;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.common.blocks.soil.ISoilBlock;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateModel;
import net.dries007.tfc.util.climate.ClimateRange;
import net.dries007.tfc.util.registry.RegistrySoilVariant;
import net.dries007.tfc.util.tracker.WorldTracker;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FarmlandBlock
extends Block
implements ISoilBlock,
HoeOverlayBlock,
IForgeBlockExtension,
EntityBlockExtension {
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private final ExtendedProperties properties;
    private final Supplier<? extends Block> dirt;

    public static Component getHydrationTooltip(Level level, BlockPos pos, ClimateRange validRange, boolean allowWiggle) {
        ChunkData data = ChunkData.get((LevelReader)level, pos);
        int totalRainHydration = FarmlandBlock.getRainHydration(level, pos);
        int hydrationValue = FarmlandBlock.getHydrationFromRainHydration(level, pos, totalRainHydration);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IFarmland) {
            IFarmland farmland = (IFarmland)blockEntity;
            int minRainfallHydration = (int)data.getMinRainfallHydration(pos);
            int minHydrationValue = FarmlandBlock.getHydrationFromRainHydration(level, pos, minRainfallHydration);
            int maxRainfallHydration = (int)data.getMaxRainfallHydration(pos);
            int maxHydrationValue = FarmlandBlock.getHydrationFromRainHydration(level, pos, maxRainfallHydration);
            MutableComponent tooltip = Component.translatable((String)"tfc.tooltip.farmland.hydration", (Object[])new Object[]{hydrationValue, minHydrationValue, maxHydrationValue});
            tooltip.append((Component)(switch (validRange.checkHydration(hydrationValue, allowWiggle)) {
                default -> throw new MatchException(null, null);
                case ClimateRange.Result.VALID -> Component.translatable((String)"tfc.tooltip.farmland.just_right");
                case ClimateRange.Result.LOW -> Component.translatable((String)"tfc.tooltip.farmland.hydration_too_low", (Object[])new Object[]{validRange.getMinHydration(allowWiggle)});
                case ClimateRange.Result.HIGH -> Component.translatable((String)"tfc.tooltip.farmland.hydration_too_high", (Object[])new Object[]{validRange.getMaxHydration(allowWiggle)});
            }));
            return tooltip;
        }
        return FarmlandBlock.getHydrationTooltip(validRange, allowWiggle, hydrationValue);
    }

    public static Component getHydrationTooltip(ClimateRange validRange, boolean allowWiggle, int hydration) {
        MutableComponent tooltip = Component.translatable((String)"tfc.tooltip.farmland.hydration_simple", (Object[])new Object[]{hydration});
        tooltip.append((Component)(switch (validRange.checkHydration(hydration, allowWiggle)) {
            default -> throw new MatchException(null, null);
            case ClimateRange.Result.VALID -> Component.translatable((String)"tfc.tooltip.farmland.just_right");
            case ClimateRange.Result.LOW -> Component.translatable((String)"tfc.tooltip.farmland.hydration_too_low", (Object[])new Object[]{validRange.getMinHydration(allowWiggle)});
            case ClimateRange.Result.HIGH -> Component.translatable((String)"tfc.tooltip.farmland.hydration_too_high", (Object[])new Object[]{validRange.getMaxHydration(allowWiggle)});
        }));
        return tooltip;
    }

    public static Component getTemperatureTooltip(Level level, BlockPos pos, ClimateRange validRange, boolean allowWiggle) {
        return FarmlandBlock.getTemperatureTooltip(level, pos, validRange, Climate.getTemperature(level, pos), allowWiggle, "tfc.tooltip.farmland.temperature");
    }

    public static Component getAverageTemperatureTooltip(Level level, BlockPos pos, ClimateRange validRange, boolean allowWiggle) {
        return FarmlandBlock.getTemperatureTooltip(level, pos, validRange, Climate.getAverageTemperature(level, pos), allowWiggle, "tfc.tooltip.climate_average_temperature");
    }

    public static Component getTemperatureTooltip(Level level, BlockPos pos, ClimateRange validRange, float temperature, boolean allowWiggle, String translationKey) {
        MutableComponent tooltip = Component.translatable((String)translationKey, (Object[])new Object[]{String.format("%.1f", Float.valueOf(temperature))});
        tooltip.append((Component)(switch (validRange.checkTemperature(temperature, allowWiggle)) {
            default -> throw new MatchException(null, null);
            case ClimateRange.Result.VALID -> Component.translatable((String)"tfc.tooltip.farmland.just_right");
            case ClimateRange.Result.LOW -> Component.translatable((String)"tfc.tooltip.farmland.temperature_too_low", (Object[])new Object[]{Float.valueOf(validRange.getMinTemperature(allowWiggle))});
            case ClimateRange.Result.HIGH -> Component.translatable((String)"tfc.tooltip.farmland.temperature_too_high", (Object[])new Object[]{Float.valueOf(validRange.getMaxTemperature(allowWiggle))});
        }));
        return tooltip;
    }

    public static int getHydration(Level level, BlockPos pos) {
        return FarmlandBlock.getHydration(level, pos, Calendars.get((LevelReader)level).getCalendarTicks());
    }

    public static int getHydration(Level level, BlockPos pos, long calendarTick) {
        return FarmlandBlock.getHydrationFromRainHydration(level, pos, FarmlandBlock.getRainHydration(level, pos, calendarTick));
    }

    public static int getHydrationFromRainHydration(Level level, BlockPos pos, int rainHydration) {
        if (Helpers.isFluid(level.getFluidState(pos.above()), TFCTags.Fluids.HYDRATING)) {
            return 100;
        }
        int waterBoost = FarmlandBlock.isSourceBlockPresent(level, pos) ? 40 : 0;
        float soilMultiplier = FarmlandBlock.getHydrationMultiplier(level, pos);
        return Mth.clamp((int)((int)((float)(waterBoost + rainHydration) * soilMultiplier)), (int)0, (int)100);
    }

    public static int getRainHydration(Level level, BlockPos pos) {
        return FarmlandBlock.getRainHydration(level, pos, Calendars.get((LevelReader)level).getCalendarTicks());
    }

    public static int getRainHydration(Level level, BlockPos pos, long calendarTick) {
        WorldTracker tracker = WorldTracker.get(level);
        ClimateModel model = tracker.getClimateModel();
        int daysInMonth = Calendars.get((LevelReader)level).getCalendarDaysInMonth();
        float rainfall = model.getRainfall((LevelReader)level, pos, calendarTick, daysInMonth);
        return FarmlandBlock.getRainHydration(rainfall);
    }

    public static int getRainHydration(float rainfall) {
        return (int)Mth.clampedMap((float)rainfall, (float)0.0f, (float)600.0f, (float)0.0f, (float)ChunkData.MAX_RAINFALL_CONTRIBUTION);
    }

    public static void turnToDirt(BlockState state, Level level, BlockPos pos) {
        level.setBlockAndUpdate(pos, FarmlandBlock.pushEntitiesUp((BlockState)state, (BlockState)((FarmlandBlock)state.getBlock()).getDirt(), (LevelAccessor)level, (BlockPos)pos));
    }

    public static float getHydrationMultiplier(Level level, BlockPos pos) {
        BlockState block = level.getBlockState(pos.below());
        if (block.is(TFCTags.Blocks.INCREASES_SOIL_HYDRATION)) {
            return 2.0f;
        }
        if (block.is(TFCTags.Blocks.DECREASES_SOIL_HYDRATION)) {
            return 0.5f;
        }
        return 1.0f;
    }

    public static boolean isSourceBlockPresent(Level level, BlockPos pos) {
        return FarmlandBlock.findMinCostWater((LevelAccessor)level, pos) < 5;
    }

    public static int findMinCostWater(LevelAccessor level, BlockPos pos) {
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        int minCostWater = 5;
        for (int dx = -4; dx <= 4; ++dx) {
            for (int dz = -4; dz <= 4; ++dz) {
                for (int dy = -1; dy <= 0; ++dy) {
                    int cost = Math.max(Math.abs(dx), Math.abs(dz)) + -2 * dy;
                    if (cost >= minCostWater || !Helpers.isFluid(level.getFluidState((BlockPos)cursor.setWithOffset((Vec3i)pos, dx, dy, dz)).getType(), TFCTags.Fluids.HYDRATING) || (minCostWater = cost) != 1) continue;
                    return 1;
                }
            }
        }
        return minCostWater;
    }

    public FarmlandBlock(ExtendedProperties properties, Supplier<? extends Block> dirt) {
        super(properties.properties());
        this.properties = properties;
        this.dirt = dirt;
    }

    FarmlandBlock(ExtendedProperties properties, RegistrySoilVariant variant) {
        this(properties, variant.getBlock(SoilBlockType.DIRT));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return CropHelpers.useFertilizer(level, player, hand, pos) ? ItemInteractionResult.sidedSuccess((boolean)level.isClientSide) : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState defaultState = this.defaultBlockState();
        return defaultState.canSurvive((LevelReader)context.getLevel(), context.getClickedPos()) ? defaultState : this.getDirt();
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP && !state.canSurvive((LevelReader)level, currentPos)) {
            level.scheduleTick(currentPos, (Block)this, 1);
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState stateAbove = level.getBlockState(pos.above());
        return !stateAbove.isSolid() || stateAbove.getBlock() instanceof FenceGateBlock || stateAbove.getBlock() instanceof MovingPistonBlock;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.tick(state, level, pos, random);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        BlockEntity blockEntity;
        if (!state.canSurvive((LevelReader)level, pos)) {
            FarmlandBlock.turnToDirt(state, (Level)level, pos);
        } else if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof IFarmland) {
            IFarmland farmland = (IFarmland)blockEntity;
            farmland.waterTick();
        }
    }

    @Override
    public BlockState getDirt() {
        return this.dirt.get().defaultBlockState();
    }

    @Override
    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, Consumer<Component> text, boolean isDebug) {
        level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.FARMLAND.get()).ifPresent(farmland -> farmland.addHoeOverlayInfo(level, pos, text, true, true));
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }
}

