/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.soil;

import net.dries007.tfc.common.blocks.soil.ISoilBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LightEngine;

public interface IGrassBlock
extends ISoilBlock {
    default public boolean canBeGrass(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos posUp = new BlockPos(pos.getX(), pos.getY() + 1, pos.getZ());
        BlockState stateUp = world.getBlockState(posUp);
        if (Helpers.isBlock(stateUp, (TagKey<Block>)BlockTags.SNOW)) {
            return true;
        }
        if (stateUp.getFluidState().getAmount() == 8) {
            return false;
        }
        return LightEngine.getLightBlockInto((BlockGetter)world, (BlockState)state, (BlockPos)pos, (BlockState)stateUp, (BlockPos)posUp, (Direction)Direction.UP, (int)stateUp.getLightBlock((BlockGetter)world, posUp)) < world.getMaxLightLevel();
    }

    default public boolean canPropagate(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos posUp = new BlockPos(pos.getX(), pos.getY() + 1, pos.getZ());
        return this.canBeGrass(state, level, pos) && level.getFluidState(posUp).isEmpty();
    }
}

