/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.soil;

import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.soil.IMudBlock;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.registry.RegistrySoilVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.Nullable;

public class TFCRootedDirtBlock
extends Block
implements IMudBlock {
    private final Supplier<? extends Block> dirt;
    private final Supplier<? extends Block> mud;

    public TFCRootedDirtBlock(BlockBehaviour.Properties properties, Supplier<? extends Block> dirt, Supplier<? extends Block> mud) {
        super(properties);
        this.dirt = dirt;
        this.mud = mud;
    }

    TFCRootedDirtBlock(BlockBehaviour.Properties properties, SoilBlockType dirtType, RegistrySoilVariant variant) {
        this(properties, variant.getBlock(dirtType), variant.getBlock(SoilBlockType.MUD));
    }

    @Override
    public BlockState getMud() {
        return this.mud.get().defaultBlockState();
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility action, boolean simulate) {
        if (context.getItemInHand().canPerformAction(action) && action == ItemAbilities.HOE_TILL && TFCConfig.SERVER.enableRootedDirtToDirtCreation.get().booleanValue()) {
            return this.dirt.get().defaultBlockState();
        }
        return null;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return this.transformToMud(this.mud.get().defaultBlockState(), level, pos, player, hand);
    }
}

