/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.wood;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.wood.VerticalSupportBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HorizontalSupportBlock
extends VerticalSupportBlock
implements IForgeBlockExtension {
    private final Map<BlockState, VoxelShape> cachedShapes = this.makeShapes(HorizontalSupportBlock.box((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), (ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());

    public HorizontalSupportBlock(ExtendedProperties properties) {
        super(properties);
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        Direction direction = null;
        for (Direction checkDir : Direction.Plane.HORIZONTAL) {
            mutablePos.set((Vec3i)pos).move(checkDir);
            if (!Helpers.isBlock(level.getBlockState((BlockPos)mutablePos), TFCTags.Blocks.SUPPORT_BEAMS)) continue;
            direction = checkDir.getOpposite();
            break;
        }
        if (direction == null) {
            return;
        }
        int distance = this.getHorizontalDistance(direction, (LevelReader)level, pos);
        if (distance == 0 || stack.getCount() < distance) {
            level.destroyBlock(pos, true);
        } else if (distance > 0) {
            stack.shrink(distance - 1);
            for (int i = 1; i < distance; ++i) {
                mutablePos.set((Vec3i)pos).move(direction, i);
                BlockState stateAt = level.getBlockState((BlockPos)mutablePos);
                if (!this.isEmptyOrValidFluid(stateAt)) continue;
                level.setBlock((BlockPos)mutablePos, (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(true))).setValue((Property)PROPERTY_BY_DIRECTION.get(direction.getOpposite()), (Comparable)Boolean.valueOf(true))).setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyForOrEmpty(stateAt.getFluidState().getType())), 2);
                mutablePos.move(Direction.DOWN);
                level.scheduleTick((BlockPos)mutablePos, level.getFluidState((BlockPos)mutablePos).getType(), 3);
            }
        }
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        if (facing.getAxis().isHorizontal()) {
            state = (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(facing), (Comparable)Boolean.valueOf(Helpers.isBlock(facingState, TFCTags.Blocks.SUPPORT_BEAMS)));
            if (!(Helpers.isBlock(facingState, TFCTags.Blocks.SUPPORT_BEAMS) && Helpers.isBlock(level.getBlockState(currentPos.relative(facing.getOpposite())), TFCTags.Blocks.SUPPORT_BEAMS) || Helpers.isBlock(level.getBlockState(currentPos.relative(facing.getClockWise())), TFCTags.Blocks.SUPPORT_BEAMS) && Helpers.isBlock(level.getBlockState(currentPos.relative(facing.getCounterClockWise())), TFCTags.Blocks.SUPPORT_BEAMS))) {
                return Blocks.AIR.defaultBlockState();
            }
        }
        return state;
    }

    @Override
    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        for (Direction d : Direction.Plane.HORIZONTAL) {
            if (this.getHorizontalDistance(d, level, pos) <= 0 || !Helpers.isBlock(level.getBlockState(pos.relative(d.getOpposite())), TFCTags.Blocks.SUPPORT_BEAMS)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = this.cachedShapes.get(state);
        if (shape != null) {
            return shape;
        }
        throw new IllegalArgumentException("Asked for Support VoxelShape that was not cached");
    }

    private int getHorizontalDistance(Direction direction, LevelReader level, BlockPos pos) {
        int distance = -1;
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 5; ++i) {
            cursor.set((Vec3i)pos).move(direction, i);
            BlockState stateAt = level.getBlockState((BlockPos)cursor);
            if (!Helpers.isBlock(stateAt, TFCTags.Blocks.SUPPORT_BEAMS) && !this.isEmptyOrValidFluid(stateAt)) {
                return 0;
            }
            cursor.move(direction, 1);
            BlockState state = level.getBlockState((BlockPos)cursor);
            if (!Helpers.isBlock(state, TFCTags.Blocks.SUPPORT_BEAMS)) continue;
            distance = i;
            break;
        }
        return distance == -1 ? 0 : distance + 1;
    }
}

