/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.wood;

import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.wood.BranchDirection;
import net.dries007.tfc.common.blocks.wood.ExtendedRotatedPillarBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.Nullable;

public class LogBlock
extends ExtendedRotatedPillarBlock {
    public static final EnumProperty<BranchDirection> BRANCH_DIRECTION = TFCBlockStateProperties.BRANCH_DIRECTION;
    @Nullable
    private final Supplier<? extends Block> stripped;

    public LogBlock(ExtendedProperties properties, @Nullable Supplier<? extends Block> stripped) {
        super(properties);
        this.stripped = stripped;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(BRANCH_DIRECTION, (Comparable)((Object)BranchDirection.NONE)));
    }

    protected float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return super.getDestroyProgress(state, player, level, pos) / (float)(((BranchDirection)((Object)state.getValue(BRANCH_DIRECTION))).natural() ? 2 : 1);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{BRANCH_DIRECTION}));
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility action, boolean simulate) {
        if (context.getItemInHand().canPerformAction(action) && action == ItemAbilities.AXE_STRIP && this.stripped != null) {
            return Helpers.copyProperties(this.stripped.get().defaultBlockState(), state);
        }
        return null;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)LogBlock.rotatePillar((BlockState)state, (Rotation)rotation).setValue(BRANCH_DIRECTION, (Comparable)((Object)((BranchDirection)((Object)state.getValue(BRANCH_DIRECTION))).rotate(rotation)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue(BRANCH_DIRECTION, (Comparable)((Object)((BranchDirection)((Object)state.getValue(BRANCH_DIRECTION))).mirror(mirror)));
    }
}

