/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.wood;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.HorizontalPipeBlock;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class VerticalSupportBlock
extends Block
implements IForgeBlockExtension,
IFluidLoggable,
HorizontalPipeBlock {
    public static final FluidProperty FLUID = TFCBlockStateProperties.WATER;
    private final Map<BlockState, VoxelShape> cachedShapes;
    private final ExtendedProperties properties;

    public VerticalSupportBlock(ExtendedProperties properties) {
        super(properties.properties());
        this.properties = properties;
        this.cachedShapes = this.makeShapes(VerticalSupportBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), (ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)FLUID, (Comparable)FLUID.keyFor(Fluids.EMPTY)));
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = this.defaultBlockState();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction d : Direction.Plane.HORIZONTAL) {
            mutablePos.setWithOffset((Vec3i)context.getClickedPos(), d);
            state = (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(d), (Comparable)Boolean.valueOf(Helpers.isBlock(context.getLevel().getBlockState((BlockPos)mutablePos), TFCTags.Blocks.SUPPORT_BEAMS)));
        }
        FluidState fluid = context.getLevel().getFluidState(context.getClickedPos());
        state = (BlockState)state.setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyForOrEmpty(fluid.getType()));
        return state;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (level.isClientSide() || placer == null) {
            return;
        }
        if (stack.getCount() > 2 && !placer.isShiftKeyDown()) {
            BlockPos above = pos.above();
            BlockPos above2 = above.above();
            BlockState stateAbove = level.getBlockState(above);
            BlockState stateAbove2 = level.getBlockState(above2);
            Fluid fluidAbove = stateAbove.getFluidState().getType();
            Fluid fluidAbove2 = stateAbove2.getFluidState().getType();
            if (this.isEmptyOrValidFluid(stateAbove) && this.isEmptyOrValidFluid(stateAbove2) && level.getEntities(null, new AABB(above)).isEmpty()) {
                level.setBlock(above, (BlockState)this.defaultBlockState().setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyForOrEmpty(fluidAbove)), 2);
                if (level.getEntities(null, new AABB(above2)).isEmpty()) {
                    level.setBlock(above2, (BlockState)this.defaultBlockState().setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyForOrEmpty(fluidAbove2)), 2);
                    stack.shrink(2);
                } else {
                    stack.shrink(1);
                }
            }
        }
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        if (facing.getAxis().isHorizontal()) {
            state = (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(facing), (Comparable)Boolean.valueOf(Helpers.isBlock(facingState, TFCTags.Blocks.SUPPORT_BEAMS)));
        } else if (facing == Direction.DOWN) {
            if (Helpers.isBlock(facingState, TFCTags.Blocks.SUPPORT_BEAMS) || facingState.isFaceSturdy((BlockGetter)level, facingPos, Direction.UP, SupportType.CENTER)) {
                return state;
            }
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowPos = pos.below();
        BlockState belowState = level.getBlockState(belowPos);
        return Helpers.isBlock(belowState, TFCTags.Blocks.SUPPORT_BEAMS) || belowState.isFaceSturdy((BlockGetter)level, belowPos, Direction.UP, SupportType.CENTER);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = this.cachedShapes.get(state);
        if (shape != null) {
            return shape;
        }
        throw new IllegalArgumentException("Asked for Support VoxelShape that was not cached");
    }

    @Override
    public FluidState getFluidState(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }

    @Override
    public FluidProperty getFluidProperty() {
        return FLUID;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, FLUID}));
    }

    protected Map<BlockState, VoxelShape> makeShapes(VoxelShape middleShape, ImmutableList<BlockState> possibleStates) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : possibleStates) {
            VoxelShape shape = middleShape;
            for (Direction d : Direction.Plane.HORIZONTAL) {
                if (!((Boolean)state.getValue((Property)PROPERTY_BY_DIRECTION.get(d))).booleanValue()) continue;
                VoxelShape joinShape = switch (d) {
                    case Direction.NORTH -> VerticalSupportBlock.box((double)5.0, (double)10.0, (double)0.0, (double)11.0, (double)16.0, (double)10.0);
                    case Direction.SOUTH -> VerticalSupportBlock.box((double)5.0, (double)10.0, (double)11.0, (double)11.0, (double)16.0, (double)16.0);
                    case Direction.EAST -> VerticalSupportBlock.box((double)11.0, (double)10.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0);
                    case Direction.WEST -> VerticalSupportBlock.box((double)0.0, (double)10.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0);
                    default -> Shapes.empty();
                };
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)joinShape);
            }
            builder.put((Object)state, (Object)shape);
        }
        return builder.build();
    }

    protected boolean isEmptyOrValidFluid(BlockState state) {
        return FluidHelpers.isAirOrEmptyFluid(state) && this.getFluidProperty().canContain(state.getFluidState().getType());
    }
}

