/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.wood;

import java.util.Locale;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.BarrelBlockEntity;
import net.dries007.tfc.common.blockentities.LoomBlockEntity;
import net.dries007.tfc.common.blockentities.SluiceBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.rotation.WaterWheelBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.WindmillBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.GroundcoverBlock;
import net.dries007.tfc.common.blocks.ShelfBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.BarrelBlock;
import net.dries007.tfc.common.blocks.devices.SluiceBlock;
import net.dries007.tfc.common.blocks.rotation.AxleBlock;
import net.dries007.tfc.common.blocks.rotation.BladedAxleBlock;
import net.dries007.tfc.common.blocks.rotation.ClutchBlock;
import net.dries007.tfc.common.blocks.rotation.EncasedAxleBlock;
import net.dries007.tfc.common.blocks.rotation.GearBoxBlock;
import net.dries007.tfc.common.blocks.rotation.WaterWheelBlock;
import net.dries007.tfc.common.blocks.rotation.WindmillBlock;
import net.dries007.tfc.common.blocks.wood.BookshelfBlock;
import net.dries007.tfc.common.blocks.wood.FallenLeavesBlock;
import net.dries007.tfc.common.blocks.wood.HorizontalSupportBlock;
import net.dries007.tfc.common.blocks.wood.LogBlock;
import net.dries007.tfc.common.blocks.wood.ScribingTableBlock;
import net.dries007.tfc.common.blocks.wood.SewingTableBlock;
import net.dries007.tfc.common.blocks.wood.TFCChestBlock;
import net.dries007.tfc.common.blocks.wood.TFCCraftingTableBlock;
import net.dries007.tfc.common.blocks.wood.TFCDoorBlock;
import net.dries007.tfc.common.blocks.wood.TFCFenceBlock;
import net.dries007.tfc.common.blocks.wood.TFCFenceGateBlock;
import net.dries007.tfc.common.blocks.wood.TFCLeavesBlock;
import net.dries007.tfc.common.blocks.wood.TFCLecternBlock;
import net.dries007.tfc.common.blocks.wood.TFCLoomBlock;
import net.dries007.tfc.common.blocks.wood.TFCPressurePlateBlock;
import net.dries007.tfc.common.blocks.wood.TFCSaplingBlock;
import net.dries007.tfc.common.blocks.wood.TFCSlabBlock;
import net.dries007.tfc.common.blocks.wood.TFCStairBlock;
import net.dries007.tfc.common.blocks.wood.TFCStandingSignBlock;
import net.dries007.tfc.common.blocks.wood.TFCTrapDoorBlock;
import net.dries007.tfc.common.blocks.wood.TFCTrappedChestBlock;
import net.dries007.tfc.common.blocks.wood.TFCWallSignBlock;
import net.dries007.tfc.common.blocks.wood.TFCWoodButtonBlock;
import net.dries007.tfc.common.blocks.wood.ToolRackBlock;
import net.dries007.tfc.common.blocks.wood.VerticalSupportBlock;
import net.dries007.tfc.common.items.BarrelBlockItem;
import net.dries007.tfc.common.items.ChestBlockItem;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

public enum Wood implements RegistryWood
{
    ACACIA(false, MapColor.TERRACOTTA_ORANGE, MapColor.TERRACOTTA_LIGHT_GRAY, 11, 210),
    ASH(false, MapColor.TERRACOTTA_PINK, MapColor.TERRACOTTA_ORANGE, 7, 10),
    ASPEN(false, MapColor.TERRACOTTA_GREEN, MapColor.TERRACOTTA_WHITE, 8, 250),
    BIRCH(false, MapColor.COLOR_BROWN, MapColor.TERRACOTTA_WHITE, 7, 145),
    BLACKWOOD(false, MapColor.COLOR_BLACK, MapColor.COLOR_BROWN, 8, 80),
    CHESTNUT(false, MapColor.TERRACOTTA_RED, MapColor.COLOR_LIGHT_GREEN, 7, 40),
    DOUGLAS_FIR(true, MapColor.TERRACOTTA_YELLOW, MapColor.TERRACOTTA_BROWN, 7, 0),
    HICKORY(false, MapColor.TERRACOTTA_BROWN, MapColor.COLOR_GRAY, 10, 230),
    KAPOK(false, MapColor.COLOR_PURPLE, MapColor.COLOR_BROWN, 7, 30),
    MANGROVE(false, MapColor.COLOR_RED, MapColor.COLOR_BROWN, 8, 100),
    MAPLE(false, MapColor.COLOR_ORANGE, MapColor.TERRACOTTA_GRAY, 7, 0),
    OAK(false, MapColor.WOOD, MapColor.COLOR_BROWN, 10, 120),
    PALM(false, MapColor.COLOR_ORANGE, MapColor.COLOR_BROWN, 7, 255),
    PINE(true, MapColor.TERRACOTTA_GRAY, MapColor.COLOR_GRAY, 7, 0),
    ROSEWOOD(false, MapColor.COLOR_RED, MapColor.TERRACOTTA_LIGHT_GRAY, 8, 170),
    SEQUOIA(true, MapColor.TERRACOTTA_RED, MapColor.TERRACOTTA_RED, 18, 0),
    SPRUCE(true, MapColor.TERRACOTTA_PINK, MapColor.TERRACOTTA_BLACK, 7, 0),
    SYCAMORE(false, MapColor.COLOR_YELLOW, MapColor.TERRACOTTA_LIGHT_GREEN, 8, 200),
    WHITE_CEDAR(true, MapColor.TERRACOTTA_WHITE, MapColor.TERRACOTTA_LIGHT_GRAY, 7, 0),
    WILLOW(false, MapColor.COLOR_GREEN, MapColor.TERRACOTTA_BROWN, 11, 225);

    public static final Wood[] VALUES;
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final boolean conifer;
    private final MapColor woodColor;
    private final MapColor barkColor;
    private final TreeGrower tree;
    private final int defaultTicksToGrow;
    private final BlockSetType blockSet;
    private final WoodType woodType;
    private final int autumnIndex;

    private Wood(boolean conifer, MapColor woodColor, MapColor barkColor, int daysToGrow, int autumnIndex) {
        this.conifer = conifer;
        this.woodColor = woodColor;
        this.barkColor = barkColor;
        this.tree = new TreeGrower(Helpers.identifier(this.serializedName).toString(), Optional.empty(), Optional.of(ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Helpers.identifier("tree/" + this.serializedName))), Optional.empty());
        this.defaultTicksToGrow = daysToGrow * 24000;
        this.autumnIndex = autumnIndex;
        this.blockSet = new BlockSetType(this.serializedName);
        this.woodType = new WoodType(Helpers.identifier(this.serializedName).toString(), this.blockSet);
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    public boolean isConifer() {
        return this.conifer;
    }

    @Override
    public BlockSetType getBlockSet() {
        return this.blockSet;
    }

    @Override
    public WoodType getVanillaWoodType() {
        return this.woodType;
    }

    @Override
    public MapColor woodColor() {
        return this.woodColor;
    }

    @Override
    public MapColor barkColor() {
        return this.barkColor;
    }

    @Override
    public TreeGrower tree() {
        return this.tree;
    }

    @Override
    public Supplier<Integer> ticksToGrow() {
        return TFCConfig.SERVER.saplingGrowthTicks.get(this);
    }

    @Override
    public int autumnIndex() {
        return this.autumnIndex;
    }

    public int defaultTicksToGrow() {
        return this.defaultTicksToGrow;
    }

    @Override
    public Supplier<Block> getBlock(BlockType type) {
        return TFCBlocks.WOODS.get(this).get((Object)type);
    }

    public static void registerBlockSetTypes() {
        for (Wood wood : VALUES) {
            BlockSetType.register((BlockSetType)wood.blockSet);
            WoodType.register((WoodType)wood.woodType);
        }
    }

    static {
        VALUES = Wood.values();
    }

    public static enum BlockType {
        LOG((self, wood) -> new LogBlock(ExtendedProperties.of(state -> state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? wood.woodColor() : wood.barkColor()).strength(8.0f).sound(SoundType.WOOD).instrument(NoteBlockInstrument.BASS).requiresCorrectToolForDrops().flammableLikeLogs(), wood.getBlock(self.stripped()))),
        STRIPPED_LOG(wood -> new LogBlock(ExtendedProperties.of(state -> state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? wood.woodColor() : wood.barkColor()).strength(7.5f).sound(SoundType.WOOD).requiresCorrectToolForDrops().flammableLikeLogs(), null)),
        WOOD((self, wood) -> new LogBlock(BlockType.properties(wood).strength(8.0f).requiresCorrectToolForDrops().flammableLikeLogs(), wood.getBlock(self.stripped()))),
        STRIPPED_WOOD(wood -> new LogBlock(BlockType.properties(wood).strength(7.5f).requiresCorrectToolForDrops().flammableLikeLogs(), null)),
        LEAVES((self, wood) -> new TFCLeavesBlock(ExtendedProperties.of().mapColor(MapColor.PLANT).strength(0.5f).sound(SoundType.GRASS).defaultInstrument().randomTicks().noOcclusion().isViewBlocking(TFCBlocks::never).flammableLikeLeaves(), wood.autumnIndex(), wood.getBlock(self.fallenLeaves()), wood.getBlock(self.twig()))),
        PLANKS(wood -> new ExtendedBlock(BlockType.properties(wood).strength(1.5f, 3.0f).flammableLikePlanks())),
        SAPLING(wood -> new TFCSaplingBlock(wood.tree(), ExtendedProperties.of(MapColor.PLANT).noCollission().randomTicks().strength(0.0f).sound(SoundType.GRASS).flammableLikeLeaves().blockEntity(TFCBlockEntities.TICK_COUNTER), wood.ticksToGrow(), wood == PALM)),
        POTTED_SAPLING(wood -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, wood.getBlock(SAPLING), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_ACACIA_SAPLING))),
        BOOKSHELF(wood -> new BookshelfBlock(BlockType.properties(wood).strength(2.0f, 3.0f).flammable(20, 30).enchantPower(BookshelfBlock::getEnchantPower).blockEntity(TFCBlockEntities.BOOKSHELF))),
        DOOR(wood -> new TFCDoorBlock(BlockType.properties(wood).strength(3.0f).noOcclusion().flammableLikePlanks(), wood.getBlockSet())),
        TRAPDOOR(wood -> new TFCTrapDoorBlock(BlockType.properties(wood).strength(3.0f).noOcclusion().flammableLikePlanks(), wood.getBlockSet())),
        FENCE(wood -> new TFCFenceBlock(BlockType.properties(wood).strength(2.0f, 3.0f).flammableLikePlanks())),
        LOG_FENCE(wood -> new TFCFenceBlock(BlockType.properties(wood).strength(2.0f, 3.0f).flammableLikeLogs())),
        FENCE_GATE(wood -> new TFCFenceGateBlock(BlockType.properties(wood).strength(2.0f, 3.0f).flammableLikePlanks())),
        BUTTON(wood -> new TFCWoodButtonBlock(ExtendedProperties.of().noCollission().strength(0.5f).sound(SoundType.WOOD).flammableLikePlanks(), wood.getBlockSet())),
        PRESSURE_PLATE(wood -> new TFCPressurePlateBlock(wood.getBlockSet(), BlockType.properties(wood).noCollission().strength(0.5f).sound(SoundType.WOOD).flammableLikePlanks())),
        SLAB(wood -> new TFCSlabBlock(BlockType.properties(wood).strength(1.5f, 3.0f).flammableLikePlanks())),
        STAIRS(wood -> new TFCStairBlock(() -> wood.getBlock(PLANKS).get().defaultBlockState(), BlockType.properties(wood).strength(1.5f, 3.0f).sound(SoundType.WOOD).flammableLikePlanks())),
        TOOL_RACK(wood -> new ToolRackBlock(BlockType.properties(wood).strength(2.0f).noOcclusion().blockEntity(TFCBlockEntities.TOOL_RACK))),
        TWIG(wood -> GroundcoverBlock.twig(ExtendedProperties.of().strength(0.05f, 0.0f).sound(SoundType.WOOD).noCollission().flammableLikeWool())),
        FALLEN_LEAVES((self, wood) -> new FallenLeavesBlock(ExtendedProperties.of().strength(0.05f, 0.0f).noOcclusion().noCollission().isViewBlocking(TFCBlocks::never).sound(SoundType.CROP).flammableLikeWool(), wood.getBlock(self.leaves()))),
        VERTICAL_SUPPORT(wood -> new VerticalSupportBlock(BlockType.properties(wood).strength(1.0f).noOcclusion().flammableLikeLogs())),
        HORIZONTAL_SUPPORT(wood -> new HorizontalSupportBlock(BlockType.properties(wood).strength(1.0f).noOcclusion().flammableLikeLogs())),
        WORKBENCH(wood -> new TFCCraftingTableBlock(BlockType.properties(wood).strength(2.5f).flammableLikeLogs())),
        TRAPPED_CHEST((self, wood) -> new TFCTrappedChestBlock(BlockType.properties(wood).strength(2.5f).flammableLikeLogs().blockEntity(TFCBlockEntities.TRAPPED_CHEST).clientTicks(ChestBlockEntity::lidAnimateTick), wood.getSerializedName()), (TriFunction<Block, Item.Properties, RegistryWood, ? extends BlockItem>)((TriFunction)ChestBlockItem::new)),
        CHEST((self, wood) -> new TFCChestBlock(BlockType.properties(wood).strength(2.5f).flammableLikeLogs().blockEntity(TFCBlockEntities.CHEST).clientTicks(ChestBlockEntity::lidAnimateTick), wood.getSerializedName()), (TriFunction<Block, Item.Properties, RegistryWood, ? extends BlockItem>)((TriFunction)ChestBlockItem::new)),
        LOOM((self, wood) -> new TFCLoomBlock(BlockType.properties(wood).strength(2.5f).noOcclusion().flammableLikePlanks().blockEntity(TFCBlockEntities.LOOM).ticks(LoomBlockEntity::tick))),
        SLUICE(wood -> new SluiceBlock(BlockType.properties(wood).strength(3.0f).noOcclusion().flammableLikeLogs().blockEntity(TFCBlockEntities.SLUICE).serverTicks(SluiceBlockEntity::serverTick))),
        SIGN(wood -> new TFCStandingSignBlock(BlockType.properties(wood).noCollission().strength(1.0f).flammableLikePlanks().blockEntity(TFCBlockEntities.SIGN).ticks(SignBlockEntity::tick), wood.getVanillaWoodType())),
        WALL_SIGN(wood -> new TFCWallSignBlock(BlockType.properties(wood).noCollission().strength(1.0f).dropsLike(wood.getBlock(SIGN)).flammableLikePlanks().blockEntity(TFCBlockEntities.SIGN).ticks(SignBlockEntity::tick), wood.getVanillaWoodType())),
        BARREL((self, wood) -> new BarrelBlock(BlockType.properties(wood).strength(2.5f).flammableLikePlanks().noOcclusion().blockEntity(TFCBlockEntities.BARREL).serverTicks(BarrelBlockEntity::serverTick)), BarrelBlockItem::new),
        LECTERN(wood -> new TFCLecternBlock(BlockType.properties(wood).noCollission().strength(2.5f).flammableLikePlanks().blockEntity(TFCBlockEntities.LECTERN))),
        SCRIBING_TABLE(wood -> new ScribingTableBlock(BlockType.properties(wood).noOcclusion().strength(2.5f).flammable(20, 30))),
        SEWING_TABLE(wood -> new SewingTableBlock(BlockType.properties(wood).noOcclusion().strength(2.5f).flammable(20, 30))),
        SHELF(wood -> new ShelfBlock(BlockType.properties(wood).noOcclusion().strength(2.5f).flammableLikePlanks().blockEntity(TFCBlockEntities.SHELF), false)),
        AXLE((self, wood) -> new AxleBlock(BlockType.properties(wood).noOcclusion().strength(2.5f).flammableLikeLogs().pushReaction(PushReaction.DESTROY).blockEntity(TFCBlockEntities.AXLE), BlockType.getBlock(wood, self.windmill()), self.planksTexture((RegistryWood)wood))),
        BLADED_AXLE((self, wood) -> new BladedAxleBlock(BlockType.properties(wood).noOcclusion().strength(2.5f).flammableLikeLogs().pushReaction(PushReaction.DESTROY).blockEntity(TFCBlockEntities.BLADED_AXLE), BlockType.getBlock(wood, self.axle()))),
        ENCASED_AXLE((self, wood) -> new EncasedAxleBlock(BlockType.properties(wood).strength(2.5f).flammableLikeLogs().pushReaction(PushReaction.DESTROY).blockEntity(TFCBlockEntities.ENCASED_AXLE))),
        CLUTCH((self, wood) -> new ClutchBlock(BlockType.properties(wood).strength(2.5f).flammableLikeLogs().pushReaction(PushReaction.DESTROY).blockEntity(TFCBlockEntities.CLUTCH), BlockType.getBlock(wood, self.axle()))),
        GEAR_BOX((self, wood) -> new GearBoxBlock(BlockType.properties(wood).strength(2.0f).noOcclusion().blockEntity(TFCBlockEntities.GEAR_BOX), BlockType.getBlock(wood, self.axle()))),
        WINDMILL((self, wood) -> new WindmillBlock(BlockType.properties(wood).strength(9.0f).noOcclusion().blockEntity(TFCBlockEntities.WINDMILL).ticks(WindmillBlockEntity::serverTick, WindmillBlockEntity::clientTick), BlockType.getBlock(wood, self.axle()))),
        WATER_WHEEL((self, wood) -> new WaterWheelBlock(BlockType.properties(wood).strength(9.0f).noOcclusion().blockEntity(TFCBlockEntities.WATER_WHEEL).ticks(WaterWheelBlockEntity::serverTick, WaterWheelBlockEntity::clientTick), BlockType.getBlock(wood, self.axle())));

        private final BiFunction<BlockType, RegistryWood, Block> blockFactory;
        private final TriFunction<Block, Item.Properties, RegistryWood, ? extends BlockItem> blockItemFactory;

        private static ExtendedProperties properties(RegistryWood wood) {
            return ExtendedProperties.of(wood.woodColor()).sound(SoundType.WOOD).instrument(NoteBlockInstrument.BASS);
        }

        private static <B extends Block> Supplier<? extends B> getBlock(RegistryWood wood, BlockType type) {
            return wood.getBlock(type);
        }

        private BlockType(Function<RegistryWood, Block> blockFactory) {
            this((BlockType self, RegistryWood wood) -> (Block)blockFactory.apply((RegistryWood)wood));
        }

        private BlockType(BiFunction<BlockType, RegistryWood, Block> blockFactory) {
            this(blockFactory, BlockItem::new);
        }

        private BlockType(BiFunction<BlockType, RegistryWood, Block> blockFactory, BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory) {
            this(blockFactory, (TriFunction<Block, Item.Properties, RegistryWood, ? extends BlockItem>)((TriFunction)(block, properties, self) -> (BlockItem)blockItemFactory.apply((Block)block, (Item.Properties)properties)));
        }

        private BlockType(BiFunction<BlockType, RegistryWood, Block> blockFactory, TriFunction<Block, Item.Properties, RegistryWood, ? extends BlockItem> blockItemFactory) {
            this.blockFactory = blockFactory;
            this.blockItemFactory = blockItemFactory;
        }

        @Nullable
        public Function<Block, BlockItem> createBlockItem(RegistryWood wood, Item.Properties properties) {
            return this.needsItem() ? block -> (BlockItem)this.blockItemFactory.apply(block, (Object)properties, (Object)wood) : null;
        }

        public String nameFor(RegistryWood wood) {
            return switch (this.ordinal()) {
                case 16 -> "wood/planks/%s_slab".formatted(wood.getSerializedName());
                case 17 -> "wood/planks/%s_stairs".formatted(wood.getSerializedName());
                default -> "wood/%s/%s".formatted(this.name().toLowerCase(Locale.ROOT), wood.getSerializedName());
            };
        }

        public boolean needsItem() {
            return switch (this.ordinal()) {
                case 7, 21, 22, 28, 29, 40 -> false;
                default -> true;
            };
        }

        private BlockType stripped() {
            return switch (this.ordinal()) {
                case 0 -> STRIPPED_LOG;
                case 2 -> STRIPPED_WOOD;
                default -> throw new IllegalStateException("Block type " + this.name() + " does not have a stripped variant");
            };
        }

        private ResourceLocation planksTexture(RegistryWood wood) {
            return Helpers.identifier("block/wood/planks/" + wood.getSerializedName());
        }

        private BlockType twig() {
            return TWIG;
        }

        private BlockType fallenLeaves() {
            return FALLEN_LEAVES;
        }

        private BlockType leaves() {
            return LEAVES;
        }

        private BlockType axle() {
            return AXLE;
        }

        private BlockType windmill() {
            return WINDMILL;
        }

        public Supplier<Block> create(RegistryWood wood) {
            return () -> this.blockFactory.apply(this, wood);
        }
    }
}

