/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities;

import net.dries007.tfc.common.capabilities.DelegateFluidHandler;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public final class PartialFluidHandler
implements DelegateFluidHandler {
    private final IFluidHandler internal;
    private final boolean insert;

    public static IFluidHandler extractOnly(IFluidHandler handler) {
        return new PartialFluidHandler(handler, false);
    }

    public static IFluidHandler insertOnly(IFluidHandler handler) {
        return new PartialFluidHandler(handler, true);
    }

    PartialFluidHandler(IFluidHandler internal, boolean insert) {
        this.internal = internal;
        this.insert = insert;
    }

    @Override
    public IFluidHandler getFluidHandler() {
        return this.internal;
    }

    @Override
    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.insert ? this.internal.fill(resource, action) : 0;
    }

    @Override
    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return !this.insert ? this.internal.drain(resource, action) : FluidStack.EMPTY;
    }

    @Override
    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return !this.insert ? this.internal.drain(maxDrain, action) : FluidStack.EMPTY;
    }
}

