/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.dries007.tfc.world.feature.vein.IVeinConfig;
import net.dries007.tfc.world.feature.vein.VeinFeature;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.server.command.EnumArgument;

public final class ClearWorldCommand {
    private static final String STARTING = "tfc.commands.clear_world.starting";
    private static final String DONE = "tfc.commands.clear_world.done";

    public static LiteralArgumentBuilder<CommandSourceStack> create() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"clearworld").requires(source -> source.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)250)).then(Commands.argument((String)"preset", (ArgumentType)EnumArgument.enumArgument(Preset.class)).executes(cmd -> ClearWorldCommand.clearWorld((CommandSourceStack)cmd.getSource(), IntegerArgumentType.getInteger((CommandContext)cmd, (String)"radius"), (Preset)((Object)((Object)cmd.getArgument("preset", Preset.class))))))).executes(cmd -> ClearWorldCommand.clearWorld((CommandSourceStack)cmd.getSource(), IntegerArgumentType.getInteger((CommandContext)cmd, (String)"radius"), Preset.ALL)));
    }

    private static int clearWorld(CommandSourceStack source, int radius, Preset preset) {
        source.sendSuccess(() -> Component.translatable((String)STARTING), true);
        ServerLevel level = source.getLevel();
        BlockPos center = BlockPos.containing((Position)source.getPosition());
        BlockState air = Blocks.AIR.defaultBlockState();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        Predicate<BlockState> predicate = preset.make(source.getServer());
        int minY = level.getMinBuildHeight();
        int blocksRemoved = 0;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                int height = level.getHeight(Heightmap.Types.WORLD_SURFACE, center.getX() + x, center.getZ() + z);
                for (int y = minY; y < height; ++y) {
                    mutablePos.set((Vec3i)center).move(x, 0, z).setY(y);
                    BlockState state = level.getBlockState((BlockPos)mutablePos);
                    if (state.isAir() || !predicate.test(state)) continue;
                    level.setBlock((BlockPos)mutablePos, air, 18);
                    ++blocksRemoved;
                }
            }
        }
        int finalBlocksRemoved = blocksRemoved;
        source.sendSuccess(() -> Component.translatable((String)DONE, (Object[])new Object[]{finalBlocksRemoved}), true);
        return 1;
    }

    static enum Preset {
        ALL(server -> state -> true),
        RAW_ROCK(server -> {
            Set blocks = TFCBlocks.ROCK_BLOCKS.values().stream().map(map -> (Block)((TFCBlocks.Id)map.get((Object)Rock.BlockType.RAW)).get()).collect(Collectors.toSet());
            return state -> blocks.contains(state.getBlock());
        }),
        EARTH(server -> {
            Set blocks = Stream.of(Stream.of(Rock.BlockType.RAW, Rock.BlockType.HARDENED, Rock.BlockType.GRAVEL).flatMap(t -> TFCBlocks.ROCK_BLOCKS.values().stream().map(map -> (Block)((TFCBlocks.Id)map.get(t)).get())), TFCBlocks.SOIL.get((Object)SoilBlockType.DIRT).values().stream().map(Supplier::get), TFCBlocks.SOIL.get((Object)SoilBlockType.GRASS).values().stream().map(Supplier::get), TFCBlocks.SAND.values().stream().map(Supplier::get)).flatMap(t -> t).collect(Collectors.toSet());
            return state -> blocks.contains(state.getBlock());
        }),
        NOT_ORE(server -> {
            Registry registry = server.registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE);
            Set blocks = registry.stream().filter(feature -> feature.feature() instanceof VeinFeature).flatMap(feature -> ((IVeinConfig)feature.config()).config().states().values().stream().flatMap(weighted -> weighted.values().stream())).map(BlockBehaviour.BlockStateBase::getBlock).collect(Collectors.toSet());
            return state -> !blocks.contains(state.getBlock());
        });

        private final Function<MinecraftServer, Predicate<BlockState>> factory;

        private Preset(Function<MinecraftServer, Predicate<BlockState>> factory) {
            this.factory = factory;
        }

        Predicate<BlockState> make(MinecraftServer server) {
            return this.factory.apply(server);
        }
    }
}

