/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component;

import net.dries007.tfc.common.component.item.ItemComponent;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public final class Bowl {
    public static final ItemComponent DISPLAY = Bowl.of(new ItemStack((ItemLike)Items.BOWL));

    public static ItemComponent of(ItemStack stack) {
        return new ItemComponent(stack.copyWithCount(1));
    }

    public static ItemStack onItemUse(ItemComponent bowl, ItemStack original, ItemStack result, LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            CriteriaTriggers.CONSUME_ITEM.trigger(player, original);
            player.awardStat(Stats.ITEM_USED.get((Object)original.getItem()));
        }
        ItemStack bowlStack = bowl.stack().copy();
        if (result.isEmpty()) {
            return bowlStack;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.getAbilities().instabuild) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)bowlStack);
            }
        }
        return result;
    }
}

