/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class CachedMut<T> {
    @Nullable
    private T value;
    private boolean loaded;

    public static <T> CachedMut<T> unloaded() {
        return new CachedMut<Object>(null, false);
    }

    public static <T> CachedMut<T> empty() {
        return new CachedMut<Object>(null, true);
    }

    public static <T> CachedMut<T> of(T value) {
        return new CachedMut<T>(value, true);
    }

    private CachedMut(@Nullable T value, boolean loaded) {
        this.value = value;
        this.loaded = loaded;
    }

    @Nullable
    public T value() {
        return this.value;
    }

    @Contract(pure=true)
    public boolean isLoaded() {
        return this.loaded;
    }

    @Contract(pure=true)
    public boolean isPresent() {
        assert (this.loaded);
        return this.value != null;
    }

    public void load(@Nullable T value) {
        assert (!this.loaded);
        this.value = value;
        this.loaded = true;
    }

    public void unload() {
        this.value = null;
        this.loaded = false;
    }

    public String toString() {
        return this.loaded ? (this.value != null ? this.value.toString() : "<empty>") : "<unloaded>";
    }

    public boolean equals(Object obj) {
        return obj instanceof CachedMut;
    }

    public int hashCode() {
        return 0;
    }
}

