/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Consumer;
import net.dries007.tfc.common.entities.livestock.OviparousAnimal;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public record EggComponent(boolean fertilized, long hatchDay, Optional<CompoundTag> entity) {
    public static final Codec<EggComponent> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.BOOL.optionalFieldOf("fertilized", (Object)false).forGetter(c -> c.fertilized), (App)Codec.LONG.optionalFieldOf("hatch_day", (Object)-1L).forGetter(c -> c.hatchDay), (App)CompoundTag.CODEC.optionalFieldOf("entity").forGetter(c -> c.entity)).apply((Applicative)i, EggComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, EggComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, c -> c.fertilized, (StreamCodec)ByteBufCodecs.VAR_LONG, c -> c.hatchDay, (StreamCodec)ByteBufCodecs.OPTIONAL_COMPOUND_TAG, c -> c.entity, EggComponent::new);
    public static final EggComponent DEFAULT = new EggComponent(false, -1L, Optional.empty());

    public static EggComponent of(OviparousAnimal entity, long hatchDay) {
        CompoundTag entityTag = new CompoundTag();
        entity.save(entityTag);
        return new EggComponent(true, hatchDay, Optional.of(entityTag));
    }

    public void addTooltipInfo(Consumer<Component> text) {
        if (this.fertilized()) {
            long remainingDays = this.hatchDay() - Calendars.CLIENT.getTotalDays();
            text.accept((Component)Component.translatable((String)"tfc.tooltip.fertilized"));
            if (remainingDays > 0L) {
                text.accept((Component)Component.translatable((String)"tfc.tooltip.egg_hatch", (Object[])new Object[]{remainingDays}));
            } else {
                text.accept((Component)Component.translatable((String)"tfc.tooltip.egg_hatch_today"));
            }
        }
    }

    public boolean canHatch() {
        return this.fertilized && this.hatchDay <= Calendars.SERVER.getTotalDays();
    }

    public Optional<Entity> hatch(Level level) {
        return this.entity.flatMap(e -> EntityType.create((CompoundTag)e, (Level)level));
    }
}

