/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.lang.reflect.Field;
import net.dries007.tfc.common.TFCTiers;
import net.dries007.tfc.common.component.EggComponent;
import net.dries007.tfc.common.component.ItemStackHooks;
import net.dries007.tfc.common.component.block.BarrelComponent;
import net.dries007.tfc.common.component.block.CrucibleComponent;
import net.dries007.tfc.common.component.fluid.FluidComponent;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.component.food.FoodComponent;
import net.dries007.tfc.common.component.food.FoodDefinition;
import net.dries007.tfc.common.component.forge.ForgingBonusComponent;
import net.dries007.tfc.common.component.forge.ForgingComponent;
import net.dries007.tfc.common.component.glass.GlassOperations;
import net.dries007.tfc.common.component.heat.HeatComponent;
import net.dries007.tfc.common.component.item.ItemComponent;
import net.dries007.tfc.common.component.item.ItemListComponent;
import net.dries007.tfc.common.component.mold.VesselComponent;
import net.dries007.tfc.common.component.size.ItemSizeManager;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryHolder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.event.ModifyDefaultComponentsEvent;
import net.neoforged.neoforge.internal.RegistrationEvents;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class TFCComponents {
    public static final DeferredRegister<DataComponentType<?>> COMPONENTS = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"tfc");
    private static final Logger LOG = LogUtils.getLogger();
    public static final Id<ForgingComponent> FORGING = TFCComponents.register("forging", ForgingComponent.CODEC, ForgingComponent.STREAM_CODEC);
    public static final Id<ForgingBonusComponent> FORGING_BONUS = TFCComponents.register("forging_bonus", ForgingBonusComponent.CODEC, ForgingBonusComponent.STREAM_CODEC);
    public static final Id<GlassOperations> GLASS = TFCComponents.register("glass", GlassOperations.CODEC, GlassOperations.STREAM_CODEC);
    public static final Id<HeatComponent> HEAT = TFCComponents.register("heat", HeatComponent.CODEC, HeatComponent.STREAM_CODEC);
    public static final Id<FoodComponent> FOOD = TFCComponents.register("food", FoodComponent.CODEC, FoodComponent.STREAM_CODEC);
    public static final Id<ItemComponent> BOWL = TFCComponents.register("bowl", ItemComponent.CODEC, ItemComponent.STREAM_CODEC);
    public static final Id<ItemListComponent> INGREDIENTS = TFCComponents.register("ingredients", ItemListComponent.CODEC, ItemListComponent.STREAM_CODEC);
    public static final Id<ItemComponent> DEPOSIT = TFCComponents.register("deposit", ItemComponent.CODEC, ItemComponent.STREAM_CODEC);
    public static final Id<ItemComponent> BAIT = TFCComponents.register("bait", ItemComponent.CODEC, ItemComponent.STREAM_CODEC);
    public static final Id<EggComponent> EGG = TFCComponents.register("egg", EggComponent.CODEC, EggComponent.STREAM_CODEC);
    public static final Id<FluidComponent> FLUID = TFCComponents.register("fluid", FluidComponent.CODEC, FluidComponent.STREAM_CODEC);
    public static final Id<VesselComponent> VESSEL = TFCComponents.register("vessel", VesselComponent.CODEC, VesselComponent.STREAM_CODEC);
    public static final Id<ItemListComponent> CONTENTS = TFCComponents.register("contents", ItemListComponent.CODEC, ItemListComponent.STREAM_CODEC);
    public static final Id<BarrelComponent> BARREL = TFCComponents.register("barrel", BarrelComponent.CODEC, BarrelComponent.STREAM_CODEC);
    public static final Id<CrucibleComponent> CRUCIBLE = TFCComponents.register("crucible", CrucibleComponent.CODEC, CrucibleComponent.STREAM_CODEC);
    private static final Field CAN_MODIFY_COMPONENTS = (Field)Helpers.uncheck(() -> {
        Field field = RegistrationEvents.class.getDeclaredField("canModifyComponents");
        field.setAccessible(true);
        return field;
    });

    public static void onModifyDefaultComponents(ModifyDefaultComponentsEvent event) {
        event.modify((ItemLike)Items.FLINT_AND_STEEL, b -> b.set(DataComponents.MAX_DAMAGE, (Object)TFCTiers.STEEL.getUses()));
        event.modify((ItemLike)Items.EGG, b -> b.set((DataComponentType)EGG.get(), (Object)EggComponent.DEFAULT));
        event.modify((ItemLike)Items.MINECART, b -> b.set(DataComponents.MAX_STACK_SIZE, (Object)64));
    }

    public static void onModifyDefaultComponentsAfterResourceReload() {
        ItemStackHooks.ENABLED = true;
        int count = 0;
        FoodProperties food = new FoodProperties.Builder().build();
        TFCComponents.setAllowComponentModifications(true);
        for (Item item : BuiltInRegistries.ITEM) {
            DataComponentPatch patch;
            ItemStack stack = new ItemStack((ItemLike)item);
            boolean hasFood = item.components().has(DataComponents.FOOD);
            @Nullable FoodDefinition foodDef = FoodCapability.getDefinition(stack);
            boolean needsFood = foodDef != null && foodDef.edible();
            int prevSize = (Integer)item.components().getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)1);
            int requestedSize = ItemSizeManager.get((ItemStack)stack).getWeight((ItemStack)stack).stackSize;
            if (hasFood == needsFood && (prevSize == 1 || prevSize == requestedSize)) continue;
            DataComponentPatch.Builder builder = DataComponentPatch.builder();
            if (hasFood) {
                builder.remove(DataComponents.FOOD);
            }
            if (needsFood) {
                builder.set(DataComponents.FOOD, (Object)food);
            }
            if (prevSize != 1 && prevSize != requestedSize) {
                builder.set(DataComponents.MAX_STACK_SIZE, (Object)requestedSize);
            }
            if ((patch = builder.build()).isEmpty()) continue;
            TFCComponents.modifyDefaultComponentsFrom(item, patch);
            ++count;
        }
        TFCComponents.setAllowComponentModifications(false);
        LOG.info("Modified default components of {} items after resource reload", (Object)count);
    }

    private static void modifyDefaultComponentsFrom(Item item, DataComponentPatch patch) {
        item.modifyDefaultComponentsFrom(patch);
    }

    private static void setAllowComponentModifications(boolean value) {
        Helpers.uncheck(() -> CAN_MODIFY_COMPONENTS.set(null, value));
    }

    private static <T> Id<T> register(String name, Codec<T> codec, StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec) {
        return new Id(COMPONENTS.register(name, () -> new DataComponentType.Builder().persistent(codec).networkSynchronized(streamCodec).build()));
    }

    public record Id<T>(DeferredHolder<DataComponentType<?>, DataComponentType<T>> holder) implements RegistryHolder<DataComponentType<?>, DataComponentType<T>>
    {
    }
}

