/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.block;

import net.dries007.tfc.common.blockentities.BarrelBlockEntity;
import net.dries007.tfc.common.component.ComponentView;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.block.BarrelComponent;
import net.dries007.tfc.common.component.fluid.FluidComponent;
import net.dries007.tfc.common.component.fluid.FluidContainer;
import net.dries007.tfc.common.component.fluid.FluidContainerInfo;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class Barrel
extends ComponentView<BarrelComponent>
implements FluidContainer,
IFluidHandlerItem {
    public Barrel(ItemStack stack) {
        super(stack, TFCComponents.BARREL, BarrelComponent.EMPTY);
    }

    public ItemStack getContainer() {
        return this.stack;
    }

    @Override
    public FluidContainerInfo containerInfo() {
        return BarrelBlockEntity.BarrelInventory.INFO;
    }

    public FluidStack getFluidInTank(int tank) {
        return ((BarrelComponent)this.component).fluidContent();
    }

    public int fill(FluidStack input, IFluidHandler.FluidAction action) {
        if (((BarrelComponent)this.component).hasActiveRecipe()) {
            return 0;
        }
        FluidComponent.FillInfo result = FluidComponent.fill(((BarrelComponent)this.component).fluidContent(), input, this.containerInfo());
        if (action.execute()) {
            this.apply(((BarrelComponent)this.component).with(result.content()));
        }
        return result.filled();
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (((BarrelComponent)this.component).hasActiveRecipe()) {
            return FluidStack.EMPTY;
        }
        FluidComponent.DrainInfo result = FluidComponent.drain(((BarrelComponent)this.component).fluidContent(), maxDrain);
        if (action.execute()) {
            this.apply(((BarrelComponent)this.component).with(result.content()));
        }
        return result.drained();
    }
}

