/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.fluid;

import com.mojang.serialization.Codec;
import net.dries007.tfc.common.component.fluid.FluidContainerInfo;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public record FluidComponent(FluidStack content) {
    public static final FluidComponent EMPTY = new FluidComponent(FluidStack.EMPTY);
    public static final Codec<FluidComponent> CODEC = FluidStack.OPTIONAL_CODEC.xmap(FluidComponent::new, FluidComponent::content);
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidComponent> STREAM_CODEC = FluidStack.OPTIONAL_STREAM_CODEC.map(FluidComponent::new, FluidComponent::content);

    public static FluidComponent of(Fluid fluid, int amount) {
        return new FluidComponent(new FluidStack(fluid, amount));
    }

    public static FillInfo fill(FluidStack content, FluidStack input, FluidContainerInfo info) {
        if (input.isEmpty() || !info.canContainFluid(input)) {
            return new FillInfo(content, 0);
        }
        if (content.isEmpty()) {
            FluidStack newContent = input.copyWithAmount(Math.min(input.getAmount(), info.fluidCapacity()));
            return new FillInfo(newContent, newContent.getAmount());
        }
        if (!FluidStack.isSameFluidSameComponents((FluidStack)content, (FluidStack)input)) {
            return new FillInfo(content, 0);
        }
        FluidStack newContent = content.copyWithAmount(Math.min(content.getAmount() + input.getAmount(), info.fluidCapacity()));
        return new FillInfo(newContent, newContent.getAmount() - content.getAmount());
    }

    public static DrainInfo drain(FluidStack content, int amount) {
        if (content.isEmpty()) {
            return new DrainInfo(content, FluidStack.EMPTY);
        }
        FluidStack newContent = amount > content.getAmount() ? FluidStack.EMPTY : content.copyWithAmount(content.getAmount() - amount);
        FluidStack newAmount = amount > content.getAmount() ? content.copy() : content.copyWithAmount(amount);
        return new DrainInfo(newContent, newAmount);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FluidComponent)) return false;
        FluidComponent that = (FluidComponent)obj;
        if (!FluidStack.matches((FluidStack)this.content, (FluidStack)that.content)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return FluidStack.hashFluidAndComponents((FluidStack)this.content);
    }

    @Override
    public String toString() {
        return "Fluid[%s mB of %s]".formatted(this.content.getAmount(), this.content.getHoverName().getString());
    }

    public record FillInfo(FluidStack content, int filled) {
    }

    public record DrainInfo(FluidStack content, FluidStack drained) {
    }
}

