/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.food;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.component.food.FoodData;
import net.dries007.tfc.common.component.food.FoodDefinition;
import net.dries007.tfc.common.component.food.FoodTrait;
import net.dries007.tfc.common.component.food.FoodTraits;
import net.dries007.tfc.common.component.food.IFood;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class FoodComponent
implements IFood {
    public static final Codec<FoodComponent> CODEC = RecordCodecBuilder.create(i -> i.group((App)FoodTraits.REGISTRY.byNameCodec().listOf().optionalFieldOf("traits", List.of()).forGetter(c -> c.traits), (App)FoodData.CODEC.optionalFieldOf("food").forGetter(c -> c.food), (App)Codec.LONG.fieldOf("creation_date").forGetter(c -> c.creationDate)).apply((Applicative)i, FoodComponent::new)).xmap(Function.identity(), FoodComponent::sanitize);
    public static final StreamCodec<RegistryFriendlyByteBuf, FoodComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry(FoodTraits.KEY).apply(ByteBufCodecs.list()), c -> c.traits, (StreamCodec)ByteBufCodecs.optional(FoodData.STREAM_CODEC), c -> c.food, (StreamCodec)ByteBufCodecs.VAR_LONG, c -> c.creationDate, FoodComponent::new);
    @Nullable
    private FoodDefinition parent;
    private final List<FoodTrait> traits;
    private final Optional<FoodData> food;
    private long creationDate;

    public FoodComponent(FoodDefinition parent) {
        this(parent, List.of(), Optional.empty(), FoodCapability.getRoundedCreationDate());
    }

    private FoodComponent(List<FoodTrait> traits, Optional<FoodData> food, long creationDate) {
        this(null, traits, food, creationDate);
    }

    private FoodComponent(@Nullable FoodDefinition parent, List<FoodTrait> traits, Optional<FoodData> food, long creationDate) {
        this.parent = parent;
        this.traits = traits;
        this.food = food;
        this.creationDate = creationDate;
    }

    @Override
    public long getCreationDate() {
        return this.sanitize().creationDate;
    }

    @Override
    public boolean isRotten() {
        return FoodCapability.isRotten(this.getCreationDate(), this.getDecayDateModifier());
    }

    @Override
    public FoodData getData() {
        return this.food.orElseGet(() -> this.parent != null ? this.parent.food() : FoodData.EMPTY);
    }

    @Override
    public List<FoodTrait> getTraits() {
        return this.traits;
    }

    FoodComponent sanitize() {
        if (this.creationDate >= 0L && this.parent != null && FoodCapability.isRotten(this.creationDate, this.getDecayDateModifier())) {
            this.creationDate = -4L;
        }
        return this;
    }

    FoodComponent with(long creationDate) {
        return new FoodComponent(this.parent, this.traits, this.food, creationDate);
    }

    FoodComponent with(FoodData food, long creationDate) {
        return new FoodComponent(this.parent, this.traits, Optional.of(food), creationDate);
    }

    FoodComponent withTraitApplied(Holder<FoodTrait> trait, long creationDate) {
        return new FoodComponent(this.parent, Helpers.immutableAdd(this.traits, (FoodTrait)trait.value()), this.food, creationDate);
    }

    FoodComponent withTraitsApplied(List<FoodTrait> others) {
        return new FoodComponent(this.parent, Helpers.immutableAddAll(this.traits, others), this.food, this.creationDate);
    }

    FoodComponent withTraitRemoved(Holder<FoodTrait> trait, long creationDate) {
        return new FoodComponent(this.parent, Helpers.immutableRemove(this.traits, (FoodTrait)trait.value()), this.food, creationDate);
    }

    public void capture(ItemStack stack) {
        if (this.parent == null) {
            this.parent = FoodCapability.getDefinition(stack);
            if (this.parent == null) {
                this.parent = FoodDefinition.DEFAULT;
            }
        }
        if (this.creationDate == -1L) {
            stack.set(TFCComponents.FOOD, (Object)new FoodComponent(this.parent, this.traits, this.food, FoodCapability.getRoundedCreationDate()));
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FoodComponent) {
            FoodComponent that = (FoodComponent)obj;
            this.sanitize();
            that.sanitize();
            return this.creationDate == that.creationDate && this.traits.equals(that.traits) && this.food.equals(that.food);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.traits, this.food);
    }

    public String toString() {
        return "Food[creationDate=%s,rotten=%s,traits=%s%s]".formatted(this.creationDate, this.isRotten(), this.traits, this.food.map(d -> ",food=" + String.valueOf(d)).orElse(""));
    }
}

