/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.food;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.dries007.tfc.common.component.food.Nutrient;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record FoodData(int hunger, float water, float saturation, int intoxication, float[] nutrients, float decayModifier) {
    private final float[] nutrients;
    public static final MapCodec<float[]> NUTRITION_CODEC = RecordCodecBuilder.mapCodec(i -> i.group(FoodData.nutrientCodec(Nutrient.GRAIN), FoodData.nutrientCodec(Nutrient.FRUIT), FoodData.nutrientCodec(Nutrient.VEGETABLES), FoodData.nutrientCodec(Nutrient.PROTEIN), FoodData.nutrientCodec(Nutrient.DAIRY)).apply((Applicative)i, (t1, t2, t3, t4, t5) -> new float[]{t1.floatValue(), t2.floatValue(), t3.floatValue(), t4.floatValue(), t5.floatValue()}));
    public static final StreamCodec<ByteBuf, float[]> NUTRITION_STREAM_CODEC = StreamCodec.of((buffer, value) -> {
        for (float t : value) {
            buffer.writeFloat(t);
        }
    }, buffer -> {
        float[] value = new float[Nutrient.TOTAL];
        for (int i = 0; i < value.length; ++i) {
            value[i] = buffer.readFloat();
        }
        return value;
    });
    private static final String INFINITY = "infinity";
    public static final MapCodec<FoodData> MAP_CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.INT.optionalFieldOf("hunger", (Object)0).forGetter(c -> c.hunger), (App)Codec.FLOAT.optionalFieldOf("water", (Object)Float.valueOf(0.0f)).forGetter(c -> Float.valueOf(c.water)), (App)Codec.FLOAT.optionalFieldOf("saturation", (Object)Float.valueOf(0.0f)).forGetter(c -> Float.valueOf(c.saturation)), (App)Codec.INT.optionalFieldOf("intoxication", (Object)0).forGetter(c -> c.intoxication), (App)NUTRITION_CODEC.forGetter(c -> c.nutrients), (App)Codec.either((Codec)Codec.FLOAT, (Codec)Codec.STRING).comapFlatMap(e -> (DataResult)e.map(DataResult::success, r -> r.equals(INFINITY) ? DataResult.success((Object)Float.valueOf(Float.POSITIVE_INFINITY)) : DataResult.error(() -> "Expected either a number or 'infinity' for decay_modifier")), e -> e.floatValue() == Float.POSITIVE_INFINITY ? Either.right((Object)INFINITY) : Either.left((Object)e)).optionalFieldOf("decay_modifier", (Object)Float.valueOf(0.0f)).forGetter(c -> Float.valueOf(c.decayModifier))).apply((Applicative)i, FoodData::new));
    public static final Codec<FoodData> CODEC = MAP_CODEC.codec();
    public static final Codec<List<FoodData>> LIST_CODEC = CODEC.listOf();
    public static final StreamCodec<ByteBuf, FoodData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, c -> c.hunger, (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.water), (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.saturation), (StreamCodec)ByteBufCodecs.VAR_INT, c -> c.intoxication, NUTRITION_STREAM_CODEC, c -> c.nutrients, (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.decayModifier), FoodData::new);
    public static final FoodData EMPTY = FoodData.ofFood(0, 0.0f, 0.0f, 0.0f);
    public static final FoodData ROTTEN = FoodData.ofFood(0, 0.0f, 0.0f, Float.POSITIVE_INFINITY);
    public static final FoodData MILK = FoodData.of(0, 0.0f).dairy(2.0f);
    public static final FoodData CAKE = FoodData.of(2, 2.0f).grain(0.8f).dairy(0.5f);

    private static RecordCodecBuilder<float[], Float> nutrientCodec(Nutrient nutrient) {
        return Codec.FLOAT.optionalFieldOf(nutrient.getSerializedName(), (Object)Float.valueOf(0.0f)).forGetter(c -> Float.valueOf(c[nutrient.ordinal()]));
    }

    public static FoodData of(float decayModifier) {
        return FoodData.ofFood(0.0f, 0.0f, decayModifier);
    }

    public static FoodData of(int hunger, float saturation) {
        return new FoodData(hunger, 0.0f, saturation, 0, new float[5], 0.0f);
    }

    public static FoodData ofFood(float saturation, float water, float decayModifier) {
        return FoodData.ofFood(4, saturation, water, decayModifier);
    }

    public static FoodData ofFood(int hunger, float saturation, float water, float decayModifier) {
        return new FoodData(hunger, water, saturation, 0, new float[5], decayModifier);
    }

    public static FoodData ofDrink(float water, int intoxication) {
        return new FoodData(0, water, 0.0f, intoxication, new float[5], 0.0f);
    }

    public float nutrient(Nutrient nutrient) {
        return this.nutrients[nutrient.ordinal()];
    }

    public float[] nutrients() {
        return (float[])this.nutrients.clone();
    }

    public FoodData grain(float value) {
        return this.with(Nutrient.GRAIN, value);
    }

    public FoodData vegetables(float value) {
        return this.with(Nutrient.VEGETABLES, value);
    }

    public FoodData fruit(float value) {
        return this.with(Nutrient.FRUIT, value);
    }

    public FoodData protein(float value) {
        return this.with(Nutrient.PROTEIN, value);
    }

    public FoodData dairy(float value) {
        return this.with(Nutrient.DAIRY, value);
    }

    public FoodData mul(float multiplier) {
        return new FoodData((int)((float)this.hunger * multiplier), this.water * multiplier, this.saturation * multiplier, this.intoxication, FoodData.mul(this.nutrients, multiplier), this.decayModifier);
    }

    public FoodData with(Nutrient nutrient, float value) {
        this.nutrients[nutrient.ordinal()] = value;
        return this;
    }

    private static float[] mul(float[] input, float multiplier) {
        float[] output = new float[input.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = input[i] * multiplier;
        }
        return output;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FoodData) {
            FoodData that = (FoodData)obj;
            return this.hunger == that.hunger && this.water == that.water && this.saturation == that.saturation && this.intoxication == that.intoxication && Arrays.equals(this.nutrients, that.nutrients) && this.decayModifier == that.decayModifier;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hunger, Float.valueOf(this.water), Float.valueOf(this.saturation), this.intoxication, Arrays.hashCode(this.nutrients), Float.valueOf(this.decayModifier));
    }
}

