/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.food;

import com.mojang.serialization.Codec;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.dries007.tfc.common.component.food.FoodTraits;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.Nullable;

public final class FoodTrait {
    public static final Codec<Holder<FoodTrait>> CODEC = FoodTraits.REGISTRY.holderByNameCodec();
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<FoodTrait>> STREAM_CODEC = ByteBufCodecs.holderRegistry(FoodTraits.KEY);
    private final Supplier<Double> decayModifier;
    @Nullable
    private final String translationKey;

    public FoodTrait(Supplier<Double> decayModifier, @Nullable String translationKey) {
        this.decayModifier = decayModifier;
        this.translationKey = translationKey;
    }

    public float getDecayModifier() {
        return this.decayModifier.get().floatValue();
    }

    public void addTooltipInfo(Consumer<Component> text) {
        if (this.translationKey != null) {
            MutableComponent component = Component.translatable((String)this.translationKey);
            if (this.getDecayModifier() > 1.0f) {
                component.withStyle(ChatFormatting.RED);
            }
            text.accept((Component)component);
        }
    }
}

