/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.food;

import java.util.function.Supplier;
import net.dries007.tfc.common.component.food.FoodTrait;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegistryBuilder;

public class FoodTraits {
    public static final ResourceKey<Registry<FoodTrait>> KEY = ResourceKey.createRegistryKey((ResourceLocation)Helpers.identifier("food_trait"));
    public static final Registry<FoodTrait> REGISTRY = new RegistryBuilder(KEY).sync(true).create();
    public static final DeferredRegister<FoodTrait> TRAITS = DeferredRegister.create(KEY, (String)"tfc");
    public static final DeferredHolder<FoodTrait, FoodTrait> SALTED = FoodTraits.register("salted", TFCConfig.SERVER.traitSaltedModifier);
    public static final DeferredHolder<FoodTrait, FoodTrait> BRINED = FoodTraits.register("brined", TFCConfig.SERVER.traitBrinedModifier);
    public static final DeferredHolder<FoodTrait, FoodTrait> PICKLED = FoodTraits.register("pickled", TFCConfig.SERVER.traitPickledModifier);
    public static final DeferredHolder<FoodTrait, FoodTrait> PRESERVED = FoodTraits.register("preserved", TFCConfig.SERVER.traitPreservedModifier);
    public static final DeferredHolder<FoodTrait, FoodTrait> PRESERVED_IN_VINEGAR = FoodTraits.register("vinegar", TFCConfig.SERVER.traitVinegarModifier);
    public static final DeferredHolder<FoodTrait, FoodTrait> CHARCOAL_GRILLED = FoodTraits.register("charcoal_grilled", TFCConfig.SERVER.traitCharcoalGrilledModifier);
    public static final DeferredHolder<FoodTrait, FoodTrait> WOOD_GRILLED = FoodTraits.register("wood_grilled", TFCConfig.SERVER.traitWoodGrilledModifier);
    public static final DeferredHolder<FoodTrait, FoodTrait> BURNT_TO_A_CRISP = FoodTraits.register("burnt_to_a_crisp", TFCConfig.SERVER.traitBurntToACrispModifier);
    public static final DeferredHolder<FoodTrait, FoodTrait> WILD = FoodTraits.register("wild", TFCConfig.SERVER.traitWildModifier);
    public static final DeferredHolder<FoodTrait, FoodTrait> CANNED = FoodTraits.register("canned", TFCConfig.SERVER.traitCannedModifier);

    private static DeferredHolder<FoodTrait, FoodTrait> register(String name, Supplier<Double> decayModifier) {
        return TRAITS.register(name, () -> new FoodTrait(decayModifier, "tfc.tooltip.food_trait." + name));
    }
}

